<?php

namespace Ptb\Grafx\Requests\Media;

use DateTime;
use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

/**
 * Creates an empty media directory in the environment
 *
 * Creates an empty media directory in the environment
 */
class CreatesEmptyMediaDirectoryInTheEnvironment extends Request implements HasBody
{
	use HasJsonBody;

	protected Method $method = Method::POST;


	public function resolveEndpoint(): string
	{
		return "/api/v1/environment/{$this->environment}/media/directory";
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $name Name of the folder to create
	 * @param string $folderPath Folder to place created media folder (NOTE: forward slashes only, should start with a slash)
	 */
	public function __construct(
		protected string $environment,
		protected string $name,
		protected string $folderPath,
	) {
	}


	public function defaultQuery(): array
	{
		return array_filter(['name' => $this->name, 'folderPath' => $this->folderPath]);
	}
}
