<?php

namespace Ptb\Grafx\Requests\Fonts;

use DateTime;
use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

/**
 * Stores font styles to a persistent storage by batch ID
 *
 * Stores font styles to a persistent storage by batch ID. Font styles that contain errors preventing
 * from uploading are being cleaned up. Returns list of affected font families
 */
class StoresFontStylesToPersistentStorageByBatchId extends Request implements HasBody
{
	use HasJsonBody;

	protected Method $method = Method::POST;


	public function resolveEndpoint(): string
	{
		return "/api/v1/environment/{$this->environment}/font-styles/temp/{$this->batchId}/confirm";
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $batchId ID of the batch
	 */
	public function __construct(
		protected string $environment,
		protected string $batchId,
	) {
	}
}
