<?php

namespace Ptb\Grafx\Requests\Fonts;

use DateTime;
use Saloon\Enums\Method;
use Saloon\Http\Request;

/**
 * Returns font style file
 *
 * Returns font style file by ID in the environment
 */
class ReturnsFontStyleFile extends Request
{
	protected Method $method = Method::GET;


	public function resolveEndpoint(): string
	{
		return "/api/v1/environment/{$this->environment}/font-styles/{$this->fontStyleId}/download";
	}


	/**
	 * @param string $environment Environment name
	 * @param string $fontStyleId ID of the font style
	 */
	public function __construct(
		protected string $environment,
		protected string $fontStyleId,
	) {
	}
}
