<?php

namespace Ptb\Grafx\Requests\Fonts;

use DateTime;
use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

/**
 * Renames font family by ID in the environment
 *
 * Renames font family by ID in the environment
 */
class RenamesFontFamilyByIdInTheEnvironment extends Request implements HasBody
{
	use HasJsonBody;

	protected Method $method = Method::PATCH;


	public function resolveEndpoint(): string
	{
		return "/api/v1/environment/{$this->environment}/font-families/{$this->fontFamilyId}";
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $fontFamilyId ID of the font family
	 */
	public function __construct(
		protected string $environment,
		protected string $fontFamilyId,
	) {
	}
}
