<?php

namespace Ptb\Grafx\Resource;

use Ptb\Grafx\Requests\Templates\CreatesNewTemplateInTheEnvironment;
use Ptb\Grafx\Requests\Templates\DeletesTemplateByIdInTheEnvironment;
use Ptb\Grafx\Requests\Templates\DownloadsTemplateByIdInTheEnvironment;
use Ptb\Grafx\Requests\Templates\ReturnsAllTemplatesAndDirectoriesInTheEnvironment;
use Ptb\Grafx\Requests\Templates\ReturnsAllTemplatesInTheEnvironmentIncludingSubfolders;
use Ptb\Grafx\Requests\Templates\ReturnsImagePreviewOfTheTemplateByIdInTheEnvironment;
use Ptb\Grafx\Requests\Templates\ReturnsPreviewGenerationTaskStatus;
use Ptb\Grafx\Requests\Templates\ReturnsTemplateByIdInTheEnvironment;
use Ptb\Grafx\Requests\Templates\ReturnsTheTemplateCollectionsThatContainTheTemplate;
use Ptb\Grafx\Requests\Templates\StoresTemplateInTemplateCollections;
use Ptb\Grafx\Requests\Templates\UpdatesTemplateByIdInTheEnvironment;
use Ptb\Grafx\Resource;
use Saloon\Http\Response;

class Templates extends Resource
{
	/**
	 * @param string $environment Name of the environment
	 * @param string $nextPageToken Next page token
	 * @param int $limit Amount of resources per response
	 * @param string $sortBy Name of the field by which the sorting is performed
	 * @param mixed $sortOrder Order of resources, ascending or descending
	 * @param string $folder Folder in which search should be done (NOTE: forward slashes only, should start with a slash)
	 * @param string $search Search by name, relativePath or resource ID
	 * @param bool $includeItemsFromSubfolders When 'true', items from subfolders are included in response
	 * @param bool $includeFolders When 'true', directory items are included in response
	 */
	public function returnsAllTemplatesInTheEnvironmentIncludingSubfolders(
		string $environment,
		?string $nextPageToken,
		?int $limit,
		?string $sortBy,
		mixed $sortOrder,
		?string $folder,
		?string $search,
		?bool $includeItemsFromSubfolders,
		?bool $includeFolders,
	): Response
	{
		return $this->connector->send(new ReturnsAllTemplatesInTheEnvironmentIncludingSubfolders($environment, $nextPageToken, $limit, $sortBy, $sortOrder, $folder, $search, $includeItemsFromSubfolders, $includeFolders));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $name Name of template
	 * @param string $folderPath Folder to place created template (NOTE: forward slashes only, should start with a slash)
	 */
	public function createsNewTemplateInTheEnvironment(string $environment, string $name, string $folderPath): Response
	{
		return $this->connector->send(new CreatesNewTemplateInTheEnvironment($environment, $name, $folderPath));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $nextPageToken Next page token
	 * @param int $limit Amount of items (resources and folders) per response
	 * @param string $sortBy Name of the field by which the sorting is performed
	 * @param mixed $sortOrder Order of resources, ascending or descending
	 * @param string $folder Folder in which search should be done (NOTE: forward slashes only, should start with a slash)
	 * @param string $search Search by name, relativePath or resource ID
	 */
	public function returnsAllTemplatesAndDirectoriesInTheEnvironment(
		string $environment,
		?string $nextPageToken,
		?int $limit,
		?string $sortBy,
		mixed $sortOrder,
		?string $folder,
		?string $search,
	): Response
	{
		return $this->connector->send(new ReturnsAllTemplatesAndDirectoriesInTheEnvironment($environment, $nextPageToken, $limit, $sortBy, $sortOrder, $folder, $search));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $templateId ID of the template
	 */
	public function returnsTemplateByIdInTheEnvironment(string $environment, string $templateId): Response
	{
		return $this->connector->send(new ReturnsTemplateByIdInTheEnvironment($environment, $templateId));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $templateId ID of the template
	 * @param string $name Name of the template
	 * @param string $folderPath Folder to move updated template (NOTE: forward slashes only, should start with a slash)
	 */
	public function updatesTemplateByIdInTheEnvironment(
		string $environment,
		string $templateId,
		?string $name,
		?string $folderPath,
	): Response
	{
		return $this->connector->send(new UpdatesTemplateByIdInTheEnvironment($environment, $templateId, $name, $folderPath));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $templateId ID of the template
	 * @param bool $force When set to 'true' template is removed from all collections
	 */
	public function deletesTemplateByIdInTheEnvironment(string $environment, string $templateId, ?bool $force): Response
	{
		return $this->connector->send(new DeletesTemplateByIdInTheEnvironment($environment, $templateId, $force));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $templateId ID of the template
	 */
	public function downloadsTemplateByIdInTheEnvironment(string $environment, string $templateId): Response
	{
		return $this->connector->send(new DownloadsTemplateByIdInTheEnvironment($environment, $templateId));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $templateId ID of the template
	 * @param string $previewType Type of preview
	 */
	public function returnsImagePreviewOfTheTemplateByIdInTheEnvironment(
		string $environment,
		string $templateId,
		?string $previewType,
	): Response
	{
		return $this->connector->send(new ReturnsImagePreviewOfTheTemplateByIdInTheEnvironment($environment, $templateId, $previewType));
	}


	/**
	 * @todo Fix duplicated method name
	 * @param string $environment Name of the environment
	 * @param string $templateId ID of the template
	 * @param string $previewType Type of preview
	 */
	public function returnsImagePreviewOfTheTemplateByIdInTheEnvironmentDuplicate1(
		string $environment,
		string $templateId,
		string $previewType,
	): Response
	{
		return $this->connector->send(new ReturnsImagePreviewOfTheTemplateByIdInTheEnvironment($environment, $templateId, $previewType));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $taskId ID of the task
	 */
	public function returnsPreviewGenerationTaskStatus(string $environment, string $taskId): Response
	{
		return $this->connector->send(new ReturnsPreviewGenerationTaskStatus($environment, $taskId));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $templateId ID of the template
	 */
	public function returnsTheTemplateCollectionsThatContainTheTemplate(
		string $environment,
		string $templateId,
	): Response
	{
		return $this->connector->send(new ReturnsTheTemplateCollectionsThatContainTheTemplate($environment, $templateId));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $templateId ID of the template
	 */
	public function storesTemplateInTemplateCollections(string $environment, string $templateId): Response
	{
		return $this->connector->send(new StoresTemplateInTemplateCollections($environment, $templateId));
	}
}
