<?php

namespace Ptb\Grafx\Requests\Templates;

use DateTime;
use Saloon\Enums\Method;
use Saloon\Http\Request;

/**
 * Stores template in template collections
 *
 * Stores template in template collections. Template is removed from all template collections that are
 * not provided in the 'collectionIds' array
 */
class StoresTemplateInTemplateCollections extends Request
{
	protected Method $method = Method::PUT;


	public function resolveEndpoint(): string
	{
		return "/api/v1/environment/{$this->environment}/templates/{$this->templateId}/template-collections";
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $templateId ID of the template
	 */
	public function __construct(
		protected string $environment,
		protected string $templateId,
	) {
	}
}
