<?php

namespace Ptb\Grafx\Requests\Templates;

use DateTime;
use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

/**
 * Creates a new template in the environment
 *
 * Creates a new template in the environment, takes template JSON from the request body
 */
class CreatesNewTemplateInTheEnvironment extends Request implements HasBody
{
	use HasJsonBody;

	protected Method $method = Method::POST;


	public function resolveEndpoint(): string
	{
		return "/api/v1/environment/{$this->environment}/templates";
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $name Name of template
	 * @param string $folderPath Folder to place created template (NOTE: forward slashes only, should start with a slash)
	 */
	public function __construct(
		protected string $environment,
		protected string $name,
		protected string $folderPath,
	) {
	}


	public function defaultQuery(): array
	{
		return array_filter(['name' => $this->name, 'folderPath' => $this->folderPath]);
	}
}
