<?php

namespace Ptb\Grafx\Requests\Output;

use DateTime;
use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

/**
 * Starts PNG output task
 *
 * Supports variable output and output settings<br />
 * Request body rules:<br />
 * Providing the
 * 'DocumentContent', 'TemplateId' or 'MyProjectId' simultaneously is not allowed<br />
 * Providing the
 * 'OutputSettingsId' and 'OutputSettings' simultaneously is not allowed<br />
 * To check structure and
 * rules for PNG output settings, please see:<br
 * />
 * [/api/v1/environment/{environment}/output/settings/png](#/Output/post_api_v1_environment__environment__output_settings_png)<br
 * />
 * IMPORTANT:<br />
 * 'LayoutsToExport' is required and should contain single layout until multiple
 * layouts to export are supported <br />
 * 'Variables' should include single variables object until
 * batch output is supported, all but first objects are ignored<br />
 * When using Swagger to execute
 * request by 'TemplateId' or 'MyProjectId' please remove default 'DocumentContent'<br />
 * When using
 * Swagger to execute request by 'OutputSettingsId' please remove default 'OutputSettings' and vice
 * versa
 */
class StartsPngOutputTask extends Request implements HasBody
{
	use HasJsonBody;

	protected Method $method = Method::POST;


	public function resolveEndpoint(): string
	{
		return "/api/v1/environment/{$this->environment}/output/png";
	}


	/**
	 * @param string $environment Name of the environment
	 */
	public function __construct(
		protected string $environment,
	) {
	}
}
