<?php

namespace Ptb\Grafx\Requests\Output;

use DateTime;
use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

/**
 * Starts JPG output task
 *
 * Supports variable output and output settings<br />
 * Request body rules:<br />
 * Providing the
 * 'DocumentContent', 'TemplateId' or 'MyProjectId' simultaneously is not allowed<br />
 * Providing the
 * 'OutputSettingsId' and 'OutputSettings' simultaneously is not allowed<br />
 * To check structure and
 * rules for JPG output settings, please see:<br
 * />
 * [/api/v1/environment/{environment}/output/settings/jpg](#/Output/post_api_v1_environment__environment__output_settings_jpg)<br
 * />
 * IMPORTANT:<br />
 * 'maxFileSizeInKiloBytes' has no effect on output at this version <br
 * />
 * 'LayoutsToExport' is required and should contain single layout until multiple layouts to export
 * are supported <br />
 * 'Variables' should include single variables object until batch output is
 * supported, all but first objects are ignored<br />
 * When using Swagger to execute request by
 * 'TemplateId' or 'MyProjectId' please remove default 'DocumentContent'<br />
 * When using Swagger to
 * execute request by 'OutputSettingsId' please remove default 'OutputSettings' and vice versa
 */
class StartsJpgOutputTask extends Request implements HasBody
{
	use HasJsonBody;

	protected Method $method = Method::POST;


	public function resolveEndpoint(): string
	{
		return "/api/v1/environment/{$this->environment}/output/jpg";
	}


	/**
	 * @param string $environment Name of the environment
	 */
	public function __construct(
		protected string $environment,
	) {
	}
}
