<?php

namespace Ptb\Grafx\Requests\Output;

use DateTime;
use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

/**
 * Starts image output task
 *
 * Providing the request body (JSON) and URL arguments (Template ID or My Project ID) simultaneously is
 * not allowed.<br />
 * IMPORTANT: When using Swagger to execute request by Template ID or My Project ID
 * please remove default request body
 */
class StartsImageOutputTask extends Request implements HasBody
{
	use HasJsonBody;

	protected Method $method = Method::POST;


	public function resolveEndpoint(): string
	{
		return "/api/v1/environment/{$this->environment}/output/image";
	}


	/**
	 * @param string $environment Name of the environment
	 * @param null|string $templateId ID of the Template
	 * @param null|string $projectId ID of My Project
	 * @param null|string $outputType Format of the output
	 * @param null|string $layoutToExport Index of template layout to export
	 * @param null|float|int $pixelRatio Pixel ratio of the animated output
	 * @param null|string $engineVersion Override engine version to use during rendering
	 */
	public function __construct(
		protected string $environment,
		protected ?string $templateId = null,
		protected ?string $projectId = null,
		protected ?string $outputType = null,
		protected ?string $layoutToExport = null,
		protected float|int|null $pixelRatio = null,
		protected ?string $engineVersion = null,
	) {
	}


	public function defaultQuery(): array
	{
		return array_filter([
			'templateId' => $this->templateId,
			'projectId' => $this->projectId,
			'outputType' => $this->outputType,
			'layoutToExport' => $this->layoutToExport,
			'pixelRatio' => $this->pixelRatio,
			'engineVersion' => $this->engineVersion,
		]);
	}
}
