<?php

namespace Ptb\Grafx\Requests\Output;

use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

/**
 * Creates GIF Output Settings
 *
 * **Name** is required and should be unique<br />
 * **Fps** is required and should be between 5 and
 * 30<br />
 * **MaxFileSizeInKiloBytes** is optional and should be positive if provided<br
 * />
 * **Scaling** should be between 0.5 and 4<br />
 */
class CreatesGifOutputSettings extends Request implements HasBody
{
	use HasJsonBody;

	protected Method $method = Method::POST;


	public function resolveEndpoint(): string
	{
		return "/api/v1/environment/{$this->environment}/output/settings/gif";
	}


	/**
	 * @param string $environment Name of the environment
	 */
	public function __construct(
		protected string $environment,
	) {
	}
}
