<?php

namespace Ptb\Grafx\Requests\MyProjects;

use DateTime;
use Saloon\Enums\Method;
use Saloon\Http\Request;

/**
 * Returns all My Projects of the current user
 *
 * Returns all My Projects of the current user
 */
class ReturnsAllMyProjectsOfTheCurrentUser extends Request
{
	protected Method $method = Method::GET;


	public function resolveEndpoint(): string
	{
		return "/api/v1/environment/{$this->environment}/projects";
	}


	/**
	 * @param string $environment Name of the environment
	 * @param null|string $nextPageToken Next page token
	 * @param null|int $limit Amount of resources per response
	 */
	public function __construct(
		protected string $environment,
		protected ?string $nextPageToken = null,
		protected ?int $limit = null,
	) {
	}


	public function defaultQuery(): array
	{
		return array_filter(['nextPageToken' => $this->nextPageToken, 'limit' => $this->limit]);
	}
}
