<?php

namespace Ptb\Grafx\Requests\Media;

use DateTime;
use Saloon\Enums\Method;
use Saloon\Http\Request;

/**
 * Updates directory in the environment
 *
 * Updates directory name or move it to another folder in the environment
 */
class UpdatesDirectoryInTheEnvironment extends Request
{
	protected Method $method = Method::PUT;


	public function resolveEndpoint(): string
	{
		return "/api/v1/environment/{$this->environment}/media/directory/{$this->directoryId}";
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $directoryId ID of the directory
	 * @param string $name The new name for the media directory
	 * @param string $folderPath Folder to move media directory (NOTE: forward slashes only, should start with a slash)
	 */
	public function __construct(
		protected string $environment,
		protected string $directoryId,
		protected string $name,
		protected string $folderPath,
	) {
	}


	public function defaultQuery(): array
	{
		return array_filter(['name' => $this->name, 'folderPath' => $this->folderPath]);
	}
}
