<?php

namespace Ptb\Grafx\Requests\Media;

use DateTime;
use Saloon\Enums\Method;
use Saloon\Http\Request;

/**
 * Returns image preview of the media by ID in the environment
 *
 * Returns image preview of the media by ID in the environment, or starts new preview generation task
 * and returns it's ID
 */
class ReturnsImagePreviewOfTheMediaByIdInTheEnvironment extends Request
{
	protected Method $method = Method::GET;


	public function resolveEndpoint(): string
	{
		return "/api/v1/environment/{$this->environment}/media/{$this->mediaId}/preview";
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $mediaId ID of the media
	 * @param null|string $previewType Type of preview
	 */
	public function __construct(
		protected string $environment,
		protected string $mediaId,
		protected ?string $previewType = null,
	) {
	}


	public function defaultQuery(): array
	{
		return array_filter(['previewType' => $this->previewType]);
	}
}
