<?php

namespace Ptb\Grafx\Requests\Fonts;

use DateTime;
use Saloon\Enums\Method;
use Saloon\Http\Request;

/**
 * Returns image preview of the preloaded font style by ID in the environment
 *
 * Returns image preview of the preloaded font style by ID in the environment
 */
class ReturnsImagePreviewOfThePreloadedFontStyleByIdInTheEnvironment extends Request
{
	protected Method $method = Method::GET;


	public function resolveEndpoint(): string
	{
		return "/api/v1/environment/{$this->environment}/font-styles/temp/{$this->batchId}/{$this->fontStyleId}/preview";
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $batchId ID of the batch
	 * @param string $fontStyleId ID of the font style
	 * @param null|string $previewFormat Format of preview
	 */
	public function __construct(
		protected string $environment,
		protected string $batchId,
		protected string $fontStyleId,
		protected ?string $previewFormat = null,
	) {
	}


	public function defaultQuery(): array
	{
		return array_filter(['previewFormat' => $this->previewFormat]);
	}
}
