<?php

namespace Ptb\Grafx\Requests\Fonts;

use DateTime;
use Saloon\Enums\Method;
use Saloon\Http\Request;

/**
 * Returns all font styles in the family
 *
 * Returns all font styles in the family
 */
class ReturnsAllFontStylesInTheFamily extends Request
{
	protected Method $method = Method::GET;


	public function resolveEndpoint(): string
	{
		return "/api/v1/environment/{$this->environment}/font-families/{$this->fontFamilyId}/styles";
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $fontFamilyId Id of the font family
	 */
	public function __construct(
		protected string $environment,
		protected string $fontFamilyId,
	) {
	}
}
