<?php

namespace Ptb\Grafx\Requests\Fonts;

use DateTime;
use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

/**
 * Renames font style by ID in the environment
 *
 * Renames font style by ID in the environment
 */
class RenamesFontStyleByIdInTheEnvironment extends Request implements HasBody
{
	use HasJsonBody;

	protected Method $method = Method::PATCH;


	public function resolveEndpoint(): string
	{
		return "/api/v1/environment/{$this->environment}/font-styles/{$this->fontStyleId}";
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $fontStyleId ID of the font style
	 */
	public function __construct(
		protected string $environment,
		protected string $fontStyleId,
	) {
	}
}
