<?php

namespace Ptb\Grafx\Requests\Fonts;

use DateTime;
use Saloon\Enums\Method;
use Saloon\Http\Request;

/**
 * Deletes preloaded font styles from the batch by IDs in the environment
 *
 * Deletes preloaded font styles from the batch by IDs in the environment
 */
class DeletesPreloadedFontStylesFromTheBatchByIdsInTheEnvironment extends Request
{
	protected Method $method = Method::DELETE;


	public function resolveEndpoint(): string
	{
		return "/api/v1/environment/{$this->environment}/font-styles/temp/{$this->batchId}";
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $batchId ID of the batch
	 * @param string $ids Comma-separated ids of preloaded font styles
	 */
	public function __construct(
		protected string $environment,
		protected string $batchId,
		protected string $ids,
	) {
	}


	public function defaultQuery(): array
	{
		return array_filter(['ids' => $this->ids]);
	}
}
