# API Wrapper for Chili GrafX

## Installation
`composer require ptbsolutions/grafx

### Update environment
`ACCUZIP_KEY={ASSIGNED_BY_ACCUZIP}`

`ACCUZIP_PAF_ID={ASSIGNED_BY_ACCUZIP}`

## Usage
```
$quote = \Ptb\Accuzip\Models\AccuzipQuote::create([
    'source_disk' => 'public',
    'source_filepath' => 'sample01.csv',
    'piece_size' => \Ptb\Accuzip\Enums\QUOTE\MailPieceSize::Card,
    'piece_height' => 6.00,
    'piece_length' => 4.00,
    'piece_thickness' => 0.009,
    'piece_weight' => 0.2,
    'mail_date' => now()->addDays(14),
    'presort_class' => \Ptb\Accuzip\Enums\QUOTE\PresortClass::FirstClass,
    'drop_zip' => 55445,
]);

app(\Ptb\Accuzip\Actions\UploadAndProcessMailFile::class)->handle(
    upload: $upload,
    allInOne: true|false (default is true)
);
```
This will upload the file storage/app/public/sample01.csv to AccuZIP and begin the quote processing. Processing can be done on an individual task basis (CASS, NCOALink, DUPS, PRESORT) or through an all in one service call. Each one of these processed will trigger a callback to the route('accuzip.callback') to update progress and update the local quote model. After each step the TaskCompleted event is triggered.

### Download mail files
```
$quote = AccuzipQuote::whereGuid($guid)->first();
if (!empty($quote)) {
    $quote->download();
}
```

The following file structure will be created in storage/app/public:
```
{GUID}/downloads/maillist.CSV
{GUID}/downloads/maildat.ZIP
{GUID}/downloads/mail.PDF
```

Note: We are not charged for API usage until the download action is triggered.
