<?php

namespace Ptb\Fedex;

use Saloon\Helpers\OAuth2\OAuthConfig;
use Saloon\Http\Connector;
use Saloon\Traits\OAuth2\ClientCredentialsGrant;

final class FedexConnector extends Connector
{
    use ClientCredentialsGrant;
    protected string $token;

    public function resolveBaseUrl(): string
    {
        return config('app.environment') === 'production' ? config('services.fedex.production_url') : config('services.fedex.sandbox_url');
    }

    public function defaultOauthConfig(): OAuthConfig
    {
        return OAuthConfig::make()
            ->setClientId(config('services.fedex.client_id'))
            ->setClientSecret(config('services.fedex.client_secret'))
            ->setTokenEndpoint('/oauth/token');
    }
}