<?php

namespace Ptb\Fedex\Actions;

use Ptb\Fedex\DataTransferObjects\Requests\RateRequestPayload;
use Ptb\Fedex\FedexConnector;
use Ptb\Fedex\Requests\RateRequest;

class GetRates
{
    public function __invoke(RateRequestPayload $payload)
    {
        try {
            $connector = new FedexConnector();

            $token = cache()->remember('fedex.access_token', now()->addHour(), function() use ($connector) {
                return $connector->getAccessToken();
            });
            $connector->authenticate($token);

            $request = new RateRequest($payload);
            $response = $connector->send($request);

            return $response->dto();
        } catch (\Exception $e) {
            return $e->getMessage();
        }
    }
}