<?php

namespace Ptb\Fedex\Requests;

use Ptb\Fedex\DataTransferObjects\Requests\RateRequestPayload;
use Ptb\Fedex\DataTransferObjects\Responses\RateRequestResponse;
use Saloon\Contracts\Body\BodyRepository;
use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Http\Response;
use Saloon\Traits\Body\HasJsonBody;

class RateRequest extends Request implements HasBody
{
    use HasJsonBody;

    protected Method $method = Method::POST;

    public function resolveEndpoint(): string
    {
        return '/rate/v1/rates/quotes';
    }

    public function __construct(readonly RateRequestPayload $payload) {}

    public function defaultHeaders(): array {
        return [
            'x-locale' => 'en_US',
        ];
    }

    public function defaultBody(): array
    {
        return [
            'accountNumber' => $this->payload->accountNumber,
            'requestedShipment' => $this->payload->requestedShipment,
            'serviceType' => $this->payload->serviceType,
            'carrierCodes' => $this->payload->carrierCodes,
        ];
    }

    public function createDtoFromResponse(Response $response): mixed
    {
        $data = $response->json();
        if (data_get($data, 'output.rateReplyDetails', false)) {
            $rateDetails = data_get($data, 'output.rateReplyDetails');
            $rates = [];
            foreach ($rateDetails as $rate) {
                foreach (data_get($rate, 'ratedShipmentDetails', []) as $detail) {
                    $rates[$rate['serviceType']] = $detail['totalNetFedExCharge'];
                }
            }

            return new RateRequestResponse(
                rates: $rates
            );
        }
        return new \Exception($response->body());
    }
}