<?php

namespace Ptb\Extensiv\Cart\Requests;

use Saloon\Enums\Method;
use Saloon\Http\Request;

class ViewOrderStatus extends Request
{
    /**
     * Define the HTTP method
     *
     * @var Method
     */
    protected Method $method = Method::GET;

    /**
     * Define the endpoint for the request
     *
     * @return string
     */
    public function resolveEndpoint(): string
    {
        return "/orders/status/{$this->reference}";
    }

    /**
     * @param string $reference
     */
    public function __construct(
        private readonly string $reference
    )
    {}
}
