<?php

namespace Ptb\Extensiv\Cart\Requests;

use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

class UpdateOrderStatus extends Request implements HasBody
{
    use HasJsonBody;

    /**
     * Define the HTTP method
     *
     * @var Method
     */
    protected Method $method = Method::POST;

    /**
     * Define the endpoint for the request
     *
     * @return string
     */
    public function resolveEndpoint(): string
    {
        return "/orders/update/{$this->reference}";
    }

    /**
     * Define the default body for the request
     *
     * @return array
     */
    public function defaultBody(): array
    {
        return [
            'order_status' => $this->status,
            'shipments' => $this->shipments,
        ];
    }

    /**
     * @param string $reference
     * @param string $status
     * @param array $shipments
     */
    public function __construct(
        private readonly string $reference,
        private readonly string $status = 'confirmed',
        private readonly array $shipments = [],
    )
    {}
}
