<?php

namespace Ptb\Extensiv\Cart\Requests;

use Illuminate\Support\Carbon;
use Saloon\Enums\Method;
use Saloon\Http\Request;

class ListOrders extends Request
{
    /**
     * Define the HTTP method
     *
     * @var Method
     */
    protected Method $method = Method::GET;

    /**
     * Define the endpoint for the request
     *
     * @return string
     */
    public function resolveEndpoint(): string
    {
        return "/orders/list/{$this->status}";
    }

    /**
     * Define the default query string for the request
     *
     * @return array
     */
    public function defaultQuery(): array
    {
        $query = [];

        if (!empty($this->fromDate)) {
            data_set($query, 'from_date', $this->fromDate->format('Y-m-d'));
        }

        if (!empty($this->toDate)) {
            data_set($query, 'to_date', $this->toDate->format('Y-m-d'));
        }

        if (!empty($this->orderSource)) {
            data_set($query, 'order_source', $this->orderSource);
        }

        data_set($query, 'limit', $this->limit);
        data_set($query, 'page', $this->page);
        data_set($query, 'include_filtered_items', $this->includeFilteredItems ? 'Y' : 'N');
        data_set($query, 'include_order_extras', $this->includeOrderExtras ? 'Y' : 'N');
        data_set($query, 'include_line_extras', $this->includeLineExtras ? 'Y' : 'N');
        data_set($query, 'include_aliases', $this->includeAliases ? 'Y' : 'N');

        return $query;
    }

    /**
     * @param string $status
     * @param Carbon|null $fromDate
     * @param Carbon|null $toDate
     * @param string|null $orderSource
     * @param int $limit
     * @param int $page
     * @param bool $includeFilteredItems
     * @param bool $includeOrderExtras
     * @param bool $includeLineExtras
     * @param bool $includeAliases
     */
    public function __construct(
        private readonly string $status = 'at_wms',
        private readonly ?Carbon $fromDate = null,
        private readonly ?Carbon $toDate = null,
        private readonly ?string $orderSource = null,
        private readonly int $limit = 20,
        private readonly int $page = 1,
        private readonly bool $includeFilteredItems = false,
        private readonly bool $includeOrderExtras = true,
        private readonly bool $includeLineExtras = true,
        private readonly bool $includeAliases = false,
    )
    {}
}
