<?php

namespace Ptb\Extensiv\Cart\Requests;

use Illuminate\Support\Carbon;
use Saloon\Enums\Method;
use Saloon\Http\Request;

class ListInventory extends Request
{
    /**
     * Define the HTTP method
     *
     * @var Method
     */
    protected Method $method = Method::GET;

    /**
     * Define the endpoint for the request
     *
     * @return string
     */
    public function resolveEndpoint(): string
    {
        return "https://api.cartrover.com/v1/merchant/inventory";
    }

    /**
     * Define default query string for request
     *
     * @return array
     */
    public function defaultQuery(): array
    {
        $query = [];

        if (!empty($this->fromDate)) {
            data_set($query, 'from_date', $this->fromDate->format('Y-m-d'));
        }

        if (!empty($this->toDate)) {
            data_set($query, 'to_date', $this->toDate->format('Y-m-d'));
        }

        data_set($query, 'limit', $this->limit);
        data_set($query, 'page', $this->page);
        data_set($query, 'include_aliases', $this->includeAliases ? 'Y' : 'N');

        return $query;
    }

    /**
     * @param Carbon|null $fromDate
     * @param Carbon|null $toDate
     * @param int $limit
     * @param int $page
     * @param bool $includeAliases
     */
    public function __construct(
        private readonly ?Carbon $fromDate = null,
        private readonly ?Carbon $toDate = null,
        private readonly int $limit = 20,
        private readonly int $page = 1,
        private readonly bool $includeAliases = false,
    )
    {}
}
