<?php

namespace Ptb\Extensiv\Cart\Requests;

use Saloon\Enums\Method;
use Saloon\Http\Request;

class GetProductInventory extends Request
{
    /**
     * Define the HTTP method
     *
     * @var Method
     */
    protected Method $method = Method::GET;

    /**
     * Define the endpoint for the request
     *
     * @return string
     */
    public function resolveEndpoint(): string
    {
        return "https://api.cartrover.com/v1/merchant/inventory/{$this->sku}";
    }

    /**
     * @param string $sku
     */
    public function __construct(
        private readonly string $sku
    )
    {}
}
