<?php

namespace Ptb\Extensiv\Cart;

use Illuminate\Support\ServiceProvider as BaseServiceProvider;
use function config_path;

class CartProvider extends BaseServiceProvider
{

    public function register(): void
    {
        app()->singleton(
            abstract: CartConnector::class,
            concrete: fn () => new CartConnector(
                user: config('services.extensiv.cart.user'),
                key: config('services.extensiv.cart.key'),
            )
        );
    }

    public function boot(): void
    {
        $this->mergeConfigFrom(__DIR__ . '/../config/services.php', 'services');
        $this->loadMigrationsFrom(__DIR__ . '/../database');
    }
}
