<?php

namespace Ptb\Extensiv\Cart;

use Saloon\Http\Connector;
use Saloon\Traits\Plugins\AcceptsJson;

class CartConnector extends Connector
{
    use AcceptsJson;

    /**
     * The Base URL of the API
     *
     * @return string
     */
    public function resolveBaseUrl(): string
    {
        return 'https://api.cartrover.com/v1/cart';
    }

    /**
     * Default headers for every request
     *
     * @return string[]
     */
    protected function defaultHeaders(): array
    {
        return [];
    }

    /**
     * @param string $user
     * @param string $key
     */
    public function __construct(
        private readonly string $user,
        private readonly string $key,
    )
    {
        $this->withBasicAuth(
            username: $user,
            password: $key,
        );
    }
}
