<?php

namespace Ptb\Extensiv\Cart\Requests;

use Saloon\Enums\Method;
use Saloon\Http\Request;

class ViewOrder extends Request
{
    /**
     * Define the HTTP method
     *
     * @var Method
     */
    protected Method $method = Method::GET;

    /**
     * Define the endpoint for the request
     *
     * @return string
     */
    public function resolveEndpoint(): string
    {
        return "/orders/{$this->reference}";
    }

    /**
     * Define the default query string for the request
     *
     * @return array
     */
    public function defaultQuery(): array
    {
        $query = [];
        data_set($query, 'include_filtered_items', $this->includeFilteredItems ? 'Y' : 'N');
        data_set($query, 'include_order_extras', $this->includeOrderExtras ? 'Y' : 'N');
        data_set($query, 'include_line_extras', $this->includeLineExtras ? 'Y' : 'N');
        data_set($query, 'include_aliases', $this->includeAliases ? 'Y' : 'N');

        return $query;
    }

    /**
     * @param string $reference
     * @param bool $includeFilteredItems
     * @param bool $includeOrderExtras
     * @param bool $includeLineExtras
     * @param bool $includeAliases
     */
    public function __construct(
        private readonly string $reference,
        private readonly bool $includeFilteredItems = false,
        private readonly bool $includeOrderExtras = true,
        private readonly bool $includeLineExtras = true,
        private readonly bool $includeAliases = false,
    )
    {}
}
