<?php

namespace Ptb\Extensiv\Cart\Requests;

use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

class NewOrderBatch extends Request implements HasBody
{
    use HasJsonBody;

    /**
     * Define the HTTP method
     *
     * @var Method
     */
    protected Method $method = Method::POST;

    /**
     * Define the endpoint for the request
     *
     * @return string
     */
    public function resolveEndpoint(): string
    {
        return '/orders/batch';
    }

    /**
     * Define the default body for the request
     *
     * @return array
     */
    public function defaultBody(): array
    {
        return $this->orders;
    }

    /**
     * @param array $order
     */
    public function __construct(
        private readonly array $orders
    )
    {}
}
