<?php

namespace Ptb\Extensiv\Cart\Requests;

use Saloon\Enums\Method;
use Saloon\Http\Request;

class GetProductInfo extends Request
{
    /**
     * Define the HTTP method
     *
     * @var Method
     */
    protected Method $method = Method::GET;

    /**
     * Define the endpoint for the request
     *
     * @return string
     */
    public function resolveEndpoint(): string
    {
        return "https://api.cartrover.com/v1/merchant/product/{$this->sku}";
    }

    /**
     * Define the query string for the request
     *
     * @return string[]
     */
    public function defaultQuery(): array
    {
        return [
            'include_parent_details' => $this->includeParentDetails ? 'Y' : 'N',
        ];
    }

    /**
     * @param string $sku
     * @param bool $includeParentDetails
     */
    public function __construct(
        private readonly string $sku,
        private readonly bool $includeParentDetails = false,
    )
    {}
}
