# Installation

## Update composer.json

Add the pointbsolutions composer repository to your composer.json file
```
"repositories": [
    {
        "type": "composer",
        "url": "https://packagist.pointbsolutions.dev"
    }
],
```
Install the package
```
composer require ptbsolutions/extensiv-cart
php artisan vendor:publish --provider=\Ptb\CartRover\Cart\PackageServiceProvider
```

## Update .env

```
EXTENSIV_CART_USER=xxxx
ESTENSIV_CART_KEY=xxxx
```

## Update config
config/services.php

```
return [
    ...
    'extensiv' => [
        'user' => env('EXTENSIV_CART_USER'),
        'key' => env('EXTENSIV_CART_KEY'), 
    ...
];
```

# Usage

## Create an order
API Doc: https://developers.cartrover.com/#665d1346-78f2-4a6d-a723-2723cdfff7ed

```
$hub = new Ptb\Extensiv\Cart\CartConnector(
    user: config('services.extensiv.user'),
    key: config('services.extensiv.key'),
);

$response = $hub->send(
    request: new Ptb\Extensiv\Cart\Requests\NewOrder(
        order: [
            'cust_ref' => '1234',
            ...
        ]
    )
);

if ($response->json('success_code')) {
    // order successfully created
}

```

## Get status of order
API Doc: https://developers.cartrover.com/#e90bdb31-6c37-47fc-8a91-56e6a840f61e

```
$reference = 'my-unique-order-reference';

$hub = new Ptb\Extensiv\Cart\CartConnector(
    user: config('services.extensiv.user'),
    key: config('services.extensiv.key'),
);

$response = $hub->send(
    request: new Ptb\Extensiv\Cart\Requests\ViewOrderStatus(
        reference: $reference
    )
);

if ($response->json('success_code')) {
    if ($response->json('response.order_status') === 'shipped') {
        $shipments = $response->json('response.order_status.shipments');
        // update my local order with shipment details
        
        // we need to update the order status in cart rover to be confirmed
        // acknowledging that we've received the shipment information
        $confirm = $hub->send(
            request: new Ptb\Extensiv\Cart\Requests\UpdateOrderStatus(
                reference: $reference,
                status: 'confirmed',
                shipments: $shipments,
            )
        );
        
        if ($confirm->json('success_code')) {
            // my confirmation was successful
        } else {
            // my confirmation request had an error
        }
    }
} else {
    // my request had an error
}
```

## Get inventory for sku
API Doc: https://developers.cartrover.com/#a97ab161-d17f-4bf1-ac4a-3d4e5021caec

```
$sku = 'my-sku';

$hub = new Ptb\Extensiv\Cart\CartConnector(
    user: config('services.extensiv.user'),
    key: config('services.extensiv.key'),
);

$response = $hub->send(
    request: new Ptb\Extensiv\Cart\Requests\GetProductInventory(
        sku: $sku
    )
);
if ($response->json('success_code')) {
    $qty_available = $response->json('response.qty_available');
    // update my local inventory
} else {
    // my request had an error
}
```
