<?php

namespace Ptb\Accuzip\Requests\PRESORT;

use Ptb\Accuzip\Enums\TaskType;
use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

class DoPresort extends Request implements HasBody
{
    use HasJsonBody;

    /**
     * Define the HTTP method
     *
     * @var Method
     */
    protected Method $method = Method::GET;

    /**
     * Define the endpoint for the request
     *
     * @return string
     */
    public function resolveEndpoint(): string
    {
        return "/servoy-service/rest_ws/ws_360/v2_0/job/{$this->guid}/PRESORT";
    }

    /**
     * Use this web service call to process addresses that have been CASS Certified through our Cloud Presort engine
     * to claim the lowest postage rates. Our Cloud Presort supports all Classes of Mail and mail-piece sizes, including
     * mixed weight manifest and drop shipment. However, for this initial proof of concept, we are releasing the
     * most popular Cloud Presort options, First-Class and Standard Mail Letters and Flats.
     *
     * The Cloud Presort settings are controlled by the “Update Quote” web service call
     *
     * @param string $guid
     */
    public function __construct(
        private readonly string $guid,
    )
    {}
}
