<?php

namespace Ptb\Accuzip\Requests\QUOTE;

use Saloon\Contracts\Body\HasBody;
use Saloon\Data\MultipartValue;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasMultipartBody;

class PostUpload extends Request implements HasBody
{

    use HasMultipartBody;

    /**
     * Define the HTTP method
     *
     * @var Method
     */
    protected Method $method = Method::POST;

    /**
     * Define the endpoint for the request
     *
     * @return string
     */
    public function resolveEndpoint(): string
    {
        return '/ws_360_webapps/v2_0/uploadProcess.jsp';
    }

    /**
     * Define the default query string for the request
     *
     * @return string[]
     */
    public function defaultQuery(): array
    {
        return [
            'manual_submit' => 'false'
        ];
    }

    /**
     * Define the default body for the request
     *
     * @return array
     */
    public function defaultBody(): array
    {
        return array_filter([
            new MultipartValue(name: 'backOfficeOption', value: 'json'),
            new MultipartValue(name: 'apiKey', value: config('services.accuzip.key')),
            new MultipartValue(name: 'callbackURL', value: $this->callbackUrl),
            new MultipartValue(name: 'guid', value: ''),
            new MultipartValue(name: 'file', value: $this->data, filename: $this->filename),
            $this->dataQualityResults ? new MultipartValue(name: 'dataQualityResults', value: $this->dataQualityResults) : null,
            $this->desCredits ? new MultipartValue(name: 'des_credits', value: $this->desCredits) : null,
            $this->colAddress ? new MultipartValue(name: 'col_address', value: $this->colAddress) : null,
            $this->colAddress2 ? new MultipartValue(name: 'col_address2', value: $this->colAddress2) : null,
            $this->colCity ? new MultipartValue(name: 'col_city', value: $this->colCity) : null,
            $this->colState ? new MultipartValue(name: 'col_st', value: $this->colState) : null,
            $this->colZip ? new MultipartValue(name: 'col_zip', value: $this->colZip) : null,
            $this->listOwnerPafId ? new MultipartValue(name: 'list_owner_paf_id', value: $this->listOwnerPafId) : null,
        ]);
    }

    /**
     * @param string $filename
     * @param string $data
     * @param string $callbackUrl
     * @param bool|null $dataQualityResults
     * @param bool|null $desCredits
     * @param string|null $colAddress
     * @param string|null $colAddress2
     * @param string|null $colCity
     * @param string|null $colState
     * @param string|null $colZip
     * @param string|null $listOwnerPafId
     */
    public function __construct(
        private readonly string $filename,
        private readonly string $data,
        private readonly string $callbackUrl,
        private readonly ?bool $dataQualityResults = null,
        private readonly ?bool $desCredits = null,
        private readonly ?string $colAddress = null,
        private readonly ?string $colAddress2 = null,
        private readonly ?string $colCity = null,
        private readonly ?string $colState = null,
        private readonly ?string $colZip = null,
        private readonly ?string $listOwnerPafId = null,
    )
    {}
}
