<?php

namespace Ptb\Accuzip\Requests\QUOTE;

use Ptb\Accuzip\Models\AccuzipQuote;
use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

class PutQuote extends Request implements HasBody
{
    use HasJsonBody;

    /**
     * Define the HTTP method
     *
     * @var Method
     */
    protected Method $method = Method::PUT;

    /**
     * Define the endpoint for the request
     *
     * @return string
     */
    public function resolveEndpoint(): string
    {
        return "/servoy-service/rest_ws/ws_360/v2_0/job/{$this->guid}/QUOTE";
    }

    /**
     * Use this web service call to update the object returned with the “Quote”, e.g., Class of Mail, Piece Size, etc... It
     * is necessary to make a call to this web service before calling the Presort web service. Otherwise, the Presort
     * web service will not know what Class of Mail or Piece Size you want to use for the presort.
     *
     * @param string $guid
     * @param array $options
     */
    public function __construct(
        private readonly string $guid,
        private readonly array $options,
    )
    {
        $filtered_options = array_filter($this->options, fn ($option) => filled($option));
        foreach ($filtered_options as $attribute => $value) {
            $this->body()->add($attribute, $value);
        }

    }
}
