<?php

namespace Ptb\Accuzip\Data;

use Ptb\Accuzip\Enums\QUOTE\MailPieceSize;
use Ptb\Accuzip\Enums\QUOTE\PresortClass;
use Ptb\Accuzip\Enums\QUOTE\TrayType;
use Spatie\LaravelData\Data;

class QuoteTemplateData extends Data
{
    public function __construct(
        /**
         * @var PresortClass Class of Mail that will be used to qualify the postage rate and presort
         * levels for the mail-pieces
         */
        public PresortClass  $presort_class,

        /**
         * @var string 5-Digit ZIP Code of Entry Post Office (BMEU) where the mail is verified
         */
        public string        $drop_zip,

        /**
         * @var MailPieceSize Mail piece size.  When using "CARD", Mail Type MUST be "FIRST CLASS"
         */
        public MailPieceSize $mail_piece_size,

        public string        $piece_height = '0.0',
        public string        $piece_length = '0.0',
        public string        $thickness_value = '0.0',

        /**
         * @var string Default value is 1.  The number of mail-pieces that where used to calculate
         * the "thickness_value=" value, e.g., thickness_value=1;  thickness_based_on=100, then each
         * piece would be calculated to be .01" thick.
         */
        public string        $thickness_based_on = '1',

        /**
         * @var TrayType
         */
        public TrayType      $tray_type = TrayType::OneFtManagedMail,

        /**
         * @var string OFF - If this setting is missing or set to "0", you will need to set the
         * Minimum and Maximum container volumes values in MIN1F, MAX1FT, MIN2FT, MAX2FT, PERTUBMIN, and PERTUBMAX
         * as applicable
         */
        public string        $calculate_container_volume = '1',

        /**
         * @var string Required if TRAY TYPE=MMM. The minimum value is 85% of MAX1FT Value. Raise to next
         * Integer, e.g., 242*.85=205.7 use 206
         */
        public string        $min1ft = '208',

        /**
         * @var string Required if TRAY TYPE=MMM.
         * The maximum value is to divide the mail-piece Thickness into 21, then use Integer value,
         * e.g., 10.25/.0425=241.176 use 241
         */
        public string        $max1ft = '244',

        /**
         * @var string For MMM, 2MM and EMM the minimum value is 85% of MAX2FT Value. Raise to next Integer,
         * e.g., 495*.85=420.75 use 421
         * For OMM - Flat Trays the minimum value is to divide the mail-piece Thickness into 8" then raise to next Integer value,
         * e.g., 8/.0425=188.235 use 189
         */
        public string        $min2ft = '421',

        /**
         * @var string For MMM and 2MM the maximum value is to divide mail-piece Thickness into 21 then use Integer value,
         * e.g., 21/.0425=494.117 use 494
         *  For EMM the maximum value is to divide mail-piece Thickness into 21.75 then use Integer value,
         * e.g., 21.75/.0425=511.764 use 511
         *  For OMM - Sacks the maximum value is to divide mail-piece Weight into 70lbs. then use Integer value,
         * e.g., 11.25/.0563=1243.339 use 1243
         */
        public string        $max2ft = '495',

        /**
         * @var string 0 = Turn Palletization Off (Default); 1 Turn Palletization On
         */
        public string        $pallets = '1',

        /**
         * @var string 0 = Turn Packages on Pallets Off (Default); 1 Turn Packages on Pallets On.
         * This setting is only applicable for Flats and Parcels
         */
        public string        $packages_on_pallets = '',

        /**
         * @var string 72 is default:
         * Minimum Linear Feet: 1' Container is 1-Linear Foot, 2' Container is 2-Linear Feet, Flat Tub is 2-Linear Feet.
         * For Sacks and Parcels, use pallet_min_pieces and pallet_max_pieces to control the Volume on each pallet.
         */
        public string        $pallet_min_trays = '72',

        /**
         * @var string 144 is default:
         * Maximum Linear Feet: 1' Container is 1-Linear Foot, 2' Container is 2-Linear Feet, Flat Tub is 2-Linear Feet.
         * For Sacks and Parcels, use pallet_min_pieces and pallet_max_pieces to control the Volume on each pallet.
         */
        public string        $pallet_max_trays = '144',

        /**
         * @var string Set calculate_container_volume=1 to auto calculate.
         * Use this setting to control the minimum number of Flat size or Parcel size pieces on a pallet.
         * Pallets can be a minimum of 250lbs. There are some optional preparations where a pallet can contain less weight.
         */
        public string        $pallet_min_pieces = '4000',

        /**
         * @var string Set calculate_container_volume=1 to auto calculate.
         * Use this setting to control the maximum number of Flat size or Parcel size pieces on a pallet.
         * Pallets can have a maximum of 2,200lbs.
         */
        public string        $pallet_max_pieces = '34400',

        /**
         * @var string 0 = Turn Loose Palletization Off (Default); 1 = Turn Loose Palletization On.
         * This option will overwrite DMM required Pallet Minimum for destination discount pallets (i.e. DSCF or DNDC) or Mixed pallet.
         */
        public string        $pallets_loose = '1',

        /**
         * @var string 0 = Do not create MXD Pallet for Packages on Pallets (Default); 1 = Create MXD Pallet for Packages on Pallets.
         * This option will create MXD Pallet for Packages on Pallet mailings. The DMM requires creating sacks with
         * the remaining bundles when presorting a Packages on Pallet mailing.
         */
        public string        $pallets_mixed = '0',

        /**
         * @var string Enter the minimum number of pieces for making DSCF Pallet.
         * If this setting exists, the pallet_loose setting will be ignored and a DSCF Pallet will not be created
         * if it contains less than the number entered here.
         */
        public string        $pallets_dscf_min = '1',

        /**
         * @var string Enter the minimum number of pieces for making DNDC Pallet.
         * If this setting exists, the pallet_loose setting will be ignored and a DNDC Pallet will not be
         * created if it contains less than the number entered here.
         */
        public string        $pallets_dbmc_min = '1',

        /**
         * @var string 0 = Off; 1 = On.
         * This option will create a MXD pallet for Packages on Pallet mailings.
         * The DMM requires making sacks with the remaining bundles in a packages on pallet mailing, but some
         * user want to create mixed pallet instead so 100% of the mail is on pallets.
         */
        public string        $mixed_containers_on_pallets = '0',

        /**
         * @var string 0 = Off; 1 = On.
         * If this option is set to 1, the optional Origin SCF Pallets will be created with no minimum for First-Class Mail
         */
        public string        $fcm_origin_scf = '0',

        /**
         * @var string 0 = Not print a barcode of any type; 1 = Printing a barcode of type POSTNET, IMb or IMpb
         */
        public string        $print_barcode = '1',

        /**
         * @var string 0 = Not Claiming Full Service IMB Rates; 1 = Claiming Full Service IMB Rates*
         *
         * To claim Full Service Rates, you must use a Full Service STID in the "imb_service_type" JSON value,
         * in addition to setting this print_imb value to 1
         */
        public string        $print_imb = '1',

        /**
         * @var string Describes the Machinability of the mail-piece
         * Possible Values: MACHINABLE, NON MACHINABLE, MANUAL
         */
        public string        $machinability = 'MACHINE',

        /**
         * @var string Weight in Pounds, Ounces, Grams, Milligrams, Kilograms
         */
        public string        $weight_value = '0.09',

        /**
         * @var string OUNCES, POUNDS, GRAMS, MILLIGRAMS, KILOGRAMS
         */
        public string        $weight_unit = 'OUNCES',

        /**
         * @var string Default value is 1.
         * The number of mail-pieces that where used to calculate the "weight_value=" value, e.g., weight_value=10;
         * weight_unit=OUNCES; weight_based_on=10, then each piece would be calculated to weigh 1oz.
         */
        public string        $weight_based_on = '1',

        /**
         * @var string Profit permit status
         * PROFIT, NONPROFIT, PROFIT (5% DISCOUNT), CLASSROOM, SCIENCE-OF-AGRICULTURE
         */
        public string        $mail_permit_type = 'PROFIT',

        /**
         * @var string Possible Values:
         * IMPRINT - Primary Postage Payment Method is Permit Imprint
         * METER - Primary Postage Payment Method is Meter
         * STAMP - Primary Postage Payment Method is Stamp
         */
        public string        $mail_pay_method = 'IMPRINT',

        /**
         * @var string Will override DMM Rule 604.5.1.2 Minimum Volume that requires the use of METER and
         * will respect user setting for 'mail_pay_method'
         */
        public string        $mail_pay_method_override = '0',

        /**
         * @var string 0 = Do not included Non-ZIP+4 records; Include Non-ZIP+4 records
         */
        public string        $include_non_zip4 = '0',

        /**
         * @var string 0 = Do not include the Carrier Route Level presort;
         * 1 = Include the Carrier Route Level presort (if applicable)
         */
        public string        $include_crrt = '0',

        /**
         * @var string 0 = Do not prepare in Reverse Order (Default); 1 = Prepare in Reverse Order
         *
         * Typically used when printing address directly on mail-piece and address print image falls face-up
         * when exiting the printer
         */
        public string        $print_reverse = '0',

        /**
         * @var string This number represents the maximum number of records you want to presort.
         * A minimum of 200 records or 50lbs. of mail is needed for Standard Mail Presort and
         * a minimum of 500 records for First-Class presort.
         */
        public string        $presort_total_records = '200',

        /**
         * @var string If set to 1, Basic Carrier Route rates will be turned off so those pieces
         * qualifying for Basic Carrier Route rates would instead qualify for 5-digit rates.
         */
        public string        $basic_crrt_off = '0',

        /**
         * @var string 0 = Periodicals (Default); 1 = News Periodicals
         */
        public string        $periodicals_news = '0',

        /**
         * @var string 0 = Do not create Firm Bundles (Default); 1 = Create Firm Bundles
         */
        public string        $periodicals_create_firm = '0',

        /**
         * @var string 0 = No Advertising; 1 = Contains Advertising
         */
        public string        $periodicals_contains_advertising = '0',

        /**
         * @var string Advertising Percentage
         */
        public string        $periodicals_advertising_percent = '',

        /**
         * @var string 3-Digit County FIPS Code, e.g., 079 = SAN LUIS OBISPO CA
         */
        public string        $periodicals_incounty_zip3 = '',

        /**
         * @var string 0 = No Ride-Along Pieces; 1 = Contains Ride-Along Pieces
         */
        public string        $periodicals_ride_along = '0',

        /**
         * @var string Weight in Pounds, Ounces, Grams, Milligrams, Kilograms based on 'weight_unit' setting
         */
        public string        $periodicals_ride_along_weight = '',

        /**
         * @var string USPS Publication Number
         */
        public string        $periodicals_publication_number = '',

        /**
         * @var string Periodical Edition or Code
         */
        public string        $periodicals_edition_code = '',

        /**
         * @var string Periodical Issue Date
         */
        public string        $periodicals_issue_date = '',

        /**
         * @var string Periodical Issue Frequency
         */
        public string        $periodicals_issue_frequency = '',

        /**
         * @var string 0 = Turn OFF DSCF Discounts; Turn ON DSCF Discounts
         */
        public string        $entry_scf = '0',

        /**
         * @var string 0 = Turn OFF DBMC Discounts; Turn ON DBMC Discounts
         */
        public string        $entry_ndc = '0',

        /**
         * @var string Enter the ZIP Codes, each separated by a semicolon that represents the ZIP Codes that you
         * would like to qualify for the DDU CRRT Rates.  Note that you will have to drop certain parts of the
         * mailing that qualify for USPS BMEU Facilities where DDU rates apply.
         */
        public string        $DDU = '',

        /**
         * @var string 1 = Qualifies all possible ZIP Codes inside the input file for the DDU Rate.
         * If a list of ZIP Codes, separated by a semicolon are provided in the "DDU" property described above,
         * the "possible ZIP Codes" that would qualify for DDU Rates would be limited to the list provided in the "DDU" property.
         * 0 or missing = Would qualify only the ZIP Codes listed in the "DDU" property for DDU Rates.
         */
        public string        $calculate_ddu_zips = '0',

        /**
         * @var string Include some or all of the DSCF ZIP Codes and Thresholds (# of mail pieces) that you
         * want to generate an 8125 Drop Ship form and qualify for the DSCF rates.
         * Setting the Threshold to zero, e.g., (0) will turn OFF the respective DSCF from qualifying any mail
         * pieces for that entry.  Unless the Threshold is met, an 8125 form and drop will not be created.
         * Each drop must be seperated by a semicolon, e.g., ;.
         *
         * Here is a complete list of DSCF's:
         * 006(0);015(0);018(0);021(0);023(0);028(0);030(0);040(0);044(0);050(0);054(0);060(0);070(0);076(0);080(0);
         * 085(0);100(0);105(0);112(0);113(0);115(0);117(0);120(0);125(0);130(0);140(0);144(0);150(0);159(0);170(0);
         * 180(0);190(0);197(0);200(0);201(0);202(0);207(0);208(0);210(0);212(0);216(0);220(0);230(0);233(0);240(0);
         * 250(0);270(0);275(0);280(0);283(0);290(0);294(0);296(0);300(0);303(0);308(0);310(0);320(0);323(0);325(0);
         * 328(0);331(0);334(0);335(0);339(0);342(0);350(0);360(0);365(0);370(0);373(0);377(0);380(0);390(0);395(0);
         * 400(0);403(0);430(0);440(0);442(0);450(0);453(0);460(0);463(0);465(0);467(0);473(0);476(0);480(0);481(0);
         * 488(0);493(0);496(0);498(0);500(0);506(0);522(0);530(0);535(0);541(0);547(0);550(0);553(0);560(0);563(0);
         * 566(0);570(0);572(0);577(0);580(0);582(0);585(0);590(0);594(0);598(0);600(0);601(0);604(0);605(0);606(0);
         * 612(0);615(0);618(0);625(0);630(0);640(0);650(0);656(0);670(0);680(0);691(0);700(0);705(0);707(0);710(0);
         * 720(0);727(0);730(0);740(0);750(0);752(0);760(0);773(0);774(0);780(0);783(0);785(0);786(0);790(0);793(0);
         * 795(0);797(0);798(0);800(0);808(0);814(0);820(0);826(0);836(0);840(0);846(0);852(0);856(0);870(0);890(0);
         * 894(0);900(0);913(0);917(0);920(0);923(0);926(0);928(0);931(0);932(0);936(0);940(0);945(0);950(0);955(0);
         * 956(0);960(0);967(0);969(0);970(0);974(0);975(0);980(0);983(0);988(0);989(0);990(0);995(0);998(0);999(0)
         *
         * Please note that the DSCF ZIP Codes change from time to time.
         *
         * For a complete list of the current DSCF ZIP Codes
         * please see: https://fast.usps.com/fast/fastApp/resources/labelListFiles.action
         */
        public string        $DSCF = '',

        /**
         * @var string Include some or all of the DNDC ZIP Codes and Thresholds (# of mail pieces) that you want to
         * generate an 8125 Drop Ship form and qualify for DNDC rates.  Setting the Threshold to zero,
         * e.g., (0) will turn OFF the respective DNDC from qualifying any mail pieces for that entry.
         *
         * Unless the Threshold is met, an 8125 form and drop will not be created.
         * Each drop must be seperated by a semicolon, e.g., ;.
         *
         * Here is a complete list of DNDC's:
         *
         * 01152(0);07097(0);140(0);15195(0);19205(0);20799(0);230(0);27075(0);280(0);302(0);32099(0);38999(0);
         * 45900(0);48399(0);50999(0);55502(0);570(0);580(0);590(0);60808(0);63001(0);66107(0);730(0);75199(0);
         * 80088(0);840(0);852(0);871(0);90299(0);94850(0);972(0);98000(0)
         *
         * Please note that the DNDC ZIP Codes change from time to time.
         *
         * For a complete list of the current DSCF ZIP Codes
         * please see: https://fast.usps.com/fast/fastApp/resources/labelListFiles.action
         */
        public string        $DNDC = '',

        /**
         * @var string Name of Mailer or Agent Signing Form
         */
        public string        $agent_or_mailer_signing_statement = '',

        /**
         * @var string Name of Mailer or Agent Company Name
         */
        public string        $agent_or_mailer_company = '',

        /**
         * @var string Name of Mailer or Agent Phone Number
         */
        public string        $agent_or_mailer_phone = '',

        /**
         * @var string Name of Mailer or Agent Email
         */
        public string        $agent_or_mailer_email = '',

        /**
         * @var string Mailing Agent - Name and Address (Separate each line with a PIPE symbol)
         */
        public string        $mailing_agent_name_address = '',

        /**
         * @var string Mailing Agent - Phone Number
         */
        public string        $mailing_agent_phone = '',

        /**
         * @var string Mailing Agent - Mailer ID
         */
        public string        $mailing_agent_mailer_id = '',

        /**
         * @var string Mailing Agent - CRID
         */
        public string        $mailing_agent_crid = '',

        /**
         * @var string Mailing Agent - eDoc Sender CRID (PostalOne! Uploads)
         */
        public string        $mailing_agent_edoc_sender_crid = '',

        /**
         * @var string Mailing Prepared For - Name and Address (Separate each line with a PIPE symbol)
         */
        public string        $prepared_for_name_address = '',

        /**
         * @var string Mailing Prepared For - Mailer ID
         */
        public string        $prepared_for_mailer_id = '',

        /**
         * @var string Mailing Prepared For - CRID
         */
        public string        $prepared_for_crid = '',

        /**
         * @var string Mailing Prepared For - Nonprofit Authorization #
         */
        public string        $prepared_for_nonprofit_authorization_number = '',

        /**
         * @var string Permit Holder - Name and Address (Separate each line with a PIPE symbol)
         */
        public string        $permit_holder_name_address = '',

        /**
         * @var string Permit Holder - Phone Number
         */
        public string        $permit_holder_phone = '',

        /**
         * @var string Permit Holder - Mailer ID
         */
        public string        $permit_holder_mailer_id = '',

        /**
         * @var string Permit Holder - CRID
         */
        public string        $permit_holder_crid = '',

        /**
         * @var string Customer Reference ID
         */
        public string        $permit_holder_caps = '',

        /**
         * @var string Permit Holder - Nonprofit Authorization #
         */
        public string        $permit_holder_nonprofit_authorization_number = '',

        /**
         * @var string Statement Sequence Number
         */
        public string        $statement_number = '',

        /**
         * @var string Mailing Date
         */
        public string        $mailing_date = '',

        /**
         * @var string Primary Permit #
         */
        public string        $mail_permit_number = '',

        /**
         * @var string Net Postage Due Permit #
         */
        public string        $net_postage_due_permit_number = '',

        /**
         * @var string Metered or Stamp only - If postage was affixed, the amount affixed to each mail-piece
         */
        public string        $postage_affixed = '',

        /**
         * @var string Metered Mail only - 0 = Exact Postage is not applied; Exact Postage is applied
         */
        public string        $exact_postage = '0',

        /**
         * @var string Ancillary Service Endorsement,NCOALink,ACS,Alternative Method,Multiple,OneCode ACS,Alternative Address Format,None
         */
        public string        $move_update_method = '',

        /**
         * @var string Date Value formated as MM/DD/YYYY.
         * You do not need to provide a Date Value for 'Alternative Address Format' or 'None'
         */
        public string        $move_update_method_date = '',

        /**
         * @var string 0 = No; Yes
         */
        public string        $political_mail = '0',

        /**
         * @var string 0 = No; Yes
         */
        public string        $election_mail = '0',

        /**
         * @var string
         */
        public string        $mail_anywhere_zip = '',

        /**
         * @var string This value represents the Mail Anywhere Account Number (MPA-1127)
         */
        public string        $mail_anywhere_act = '',

        /**
         * @var string This value represents the ZIP+4 code for the BMEU where the mail will be verified.
         * This may be the same as the mail_anywhere_zip.
         */
        public string        $verification_facility_zip4 = '',

        /**
         * @var string 0=Tracking Only (Default); 1=Postage & Tracking eVS; 2=Tracking Only
         */
        public string        $electronic_file_type = '1',

        /**
         * @var string Payment system used for mailing:
         * ‘01’ Permit System
         * ‘03’ Federal Agency
         * ‘04’ PC Postage
         * ‘05’ Smart Meter
         * ‘06’ Other Meter
         * ‘07’ Stamps
         */
        public string        $evs_method_of_payment = '01',

        /**
         * @var string Important: DO NOT LEAVE THIS SETTING BLANK.
         * YOU MUST USE YOUR OWN MAILER ID.
         * YOU CANNOT USE OUR ACCUZIP MAILER ID.
         *
         * This is the Mailer ID that will be printed in the IMb that is printed on the mail-piece
         *
         * This is also the Mailer ID that will be written to the Mail.dat files (.pbc and .pdr)
         *
         * PBC - Byte Position 37 - 41
         * PDR - Byte Postion 94 - 99
         */
        public string        $imb_default_mid = '',

        /**
         * @var string IMB MID= overwrites DEFAULT MID=.
         *
         * YOU MUST USE YOUR OWN MAILER ID.
         * YOU CANNOT USE OUR ACCUZIP MAILER ID.
         *
         * If a value is provided in IMB MID= this value will replace the value provided in DEFAULT IMB=
         * and be written to the IMb and .pbc or .pdr
         */
        public string        $imb_mid = '',

        /**
         * @var string This number is IGNORED if IMBMID= is empty or missing
         *
         * Note: The Cloud will keep track of the Starting Serial Number for DEFAULTMID=.
         *
         * This number represents the Starting Serial Number that will be in the IMb that is printed
         * on the mail-piece, .pbc and .pdr
         *
         * For 6-Digit Mailer ID's the max length is 9 for Serial Number
         *
         * For 9-Digit Mailer ID's the max length is 6 for Serial Number
         */
        public string        $imb_starting_serial_number = '1',

        /**
         * @var string FCM Destination Confirm (Full-Service - IMb Tracing)
         * Table: see "Table of Service Type Identifiers" (https://ribbs.usps.gov/index.cfm?page=intellmailmailpieces)
         *
         * Note: If this setting is blank or missing, our Cloud process will default to the
         * "Destination Confirm (Full-Service - IMb Tracing)" service type for the Class of Mail in presort
         *
         * Important: Make certain that the correct Service Type is used for the Class of Mail.
         *
         * For example, do not use Service Type 271 for First-Class Mail.
         *
         * Service Type 271 is a Standard Mail Service Type.
         */
        public string        $imb_service_type = '',

        /**
         * @var string This Service Type will be used for non-ZIP+4 records
         */
        public string        $imb_service_type_basic = '',

        /**
         * @var string 1 = Keep original IMb/IMpb from Input File (if it exists); 0 or missing = Replace or Add new IMb/IMpb
         */
        public string        $imb_keep_original = '1',

        /**
         * @var string 1 = Force 'presort_class' setting to prepare mail even if minimum mail volume is not established;
         * 0 or missing = Automatically switch to First-Class Mail if 'presort_class' minimum volumes are not established
         */
        public string        $force_presort_class = '0',

        /**
         * @var string 1 = Maildat.pdr will be created instead of the Maildat.pbc
         * 0 = Maildat.pbc will be created instead of the Maildat.pdr
         *
         * Note: If this setting or section does not exist, the Maildat.pbc will be created instead of the Maildat.pdr
         */
        public string        $maildat_pdr = '1',

        /**
         * @var string The name used to identify a specific marketing campaign
         */
        public string        $maildat_mpu_name = '',

        /**
         * @var string This is a unique name or code for each specific version being created within this mailing
         */
        public string        $maildat_mpu_description = '',

        /**
         * @var string This must be a unique value for 45-days and is used in PostalOne! to identify a job.
         *
         * Leave this blank and our RESTful web services Direct Mail process will automatically assign a Unique JOB ID
         */
        public string        $maildat_jobid = '',

        /**
         * @var string Licensed User's Job Number - The Licensed User’s (who created this iteration of Mail.dat)
         * internal Job Number
         */
        public string        $maildat_userid = '',

        /**
         * @var string Job Name/Title & Issue - Applicable Job, Title-Issue, Campaign Name, or description
         */
        public string        $maildat_jobtitle = '',

        /**
         * @var string User Defined Grouping. A value that associates multiple containers for the
         * convenience of the mailing facility.
         */
        public string        $maildat_container_grouping_description = '',

        /**
         * @var string 1 = Presort as Manifest Mailing (Commingle); 0 or missing = Prepare as regular Presort Mailing (Default).
         *
         * If 'maildat_commingle' is set to 1, you must provide mapping information to your mailing list columns
         * for 'col_crid_of_mail_owner', 'col_permit_no' and 'col_permit_zip'.
         *
         * See 'MANIFEST INFORMATION' section below.
         */
        public string        $maildat_commingle = '0',

        /**
         * @var string 1=Ignore maildat_jobid and create a Unique MAIL.DAT  Job ID,
         * 0 or missing use maildat_jobid MAIL.DAT Job ID.
         */
        public string        $maildat_unique_jobid = '1',

        /**
         * @var string User defined or client requested information
         */
        public string        $user_information_line1 = '',

        /**
         * @var string User defined or client requested information
         */
        public string        $user_information_line2 = '',

        /**
         * @var string MAIL.dat Component Characteristics Record (CCR) - Characteristic Type
         * Possible Values: C,I,F
         */
        public string        $characteristic_type = '',

        /**
         * @var string "MAIL.dat Component Characteristics Record (CCR) - Characteristic
         * CT = Catalog
         * RR = Earned Value Reply Mail Promotion
         * NF = Contents NOT required to be mailed FCM
         * DC = DVD/CD or other disk
         * PS = Product Sample
         * RT = Round Trip ONLY: One DVD/CD or other disk (can be LT or FL)
         * MI = Mobile Shopping Promotion
         * NP = PACT act
         * 0X = User Option
         * 3X = User Option
         * 6X = User Option
         * 9X = User Option
         * SS = Tactile, Sensory and Interactive Mailpiece Engagement Promotion
         * MT = Mailer Type
         * VV = Volume w/% off
         * VP = Volume w/price off
         * RE = Revenue
         * PI = Informed Delivery Promotion
         * EM = Election Mail
         * PM = Political Mail
         * SB = Small Bus w/% off
         * IV = Invoice
         * 1X = User Option
         * 4X = User Option
         * 7X = User Option
         * OS = Operational Surcharge
         * GS = Geographic Surcharge
         * PP = Picture Permit Indicia
         * CB = Certificate of Bulk Mailing
         * ME = Emerging and Advanced Technology Promotion
         * AD = Advertising
         * CP = Personalized Color Transpromo Promotion
         * HM = Hazardous Material
         * CO = Coupon Promotion
         * HD = High Density
         * 2X = User Option
         * 5X = User Option
         * 8X = User Option"
         */
        public string        $characteristic = '',

        /**
         * @var string TEM = Test Environment; PROD = Production Environment; PREPROD = Preproduction Environment
         */
        public string        $p1_env = '',

        /**
         * @var string Username for the USPS Gateway (https://gateway.usps.com/eAdmin/view/signin)
         */
        public string        $p1_usr = '',

        /**
         * @var string Password for the USPS Gateway (https://gateway.usps.com/eAdmin/view/signin)
         */
        public string        $p1_psw = '',

        /**
         * @var string UPLOAD = Upload new Mail.dat;
         * CANCEL = Cancel existing PostalOne! Job;
         * DELETE = Delete PostalOne Job (Delete can be called without CANCEL and will automatically Cancel, then Delete PostalOne! Job;
         * UPDATE = Update an existing PostalOne! Job
         */
        public string        $p1_action = '',

        public string        $accutrace_job_description = '',

        /**
         * @var string The default value will be the MAIL.DAT JOB ID if this setting is left empty
         */
        public string        $accutrace_job_id = '',

        /**
         * @var string This could be used as an Internal Job ID and can be up to 20-characters in length
         */
        public string        $accutrace_job_id2 = '',

        /**
         * @var string This is the email address that will receive the Job Notification that the job has
         * been imported into AccuTrace. Separate multiple email addresses with a semicolon
         */
        public string        $accutrace_notice_email = '',

        public string        $accutrace_customer_id = '',

        public string        $accutrace_api_key = '',

        /**
         * @var string This date is used for the In Home Delivery Performance in AccuTrace.
         * This should reflect the Date which you believe the mail should start arriving in-home.
         * This date cannot be earlier than the Mailing Date or after the  accutrace_in_home_end_date.
         * This date defaults to +3 from the Mailing Date
         */
        public string        $accutrace_in_home_start_date = '',

        /**
         * @var string This date is used for the In Home Delivery Performance in AccuTrace.
         * This should reflect the Date which you believe the mail should be completed with arriving in-home.
         * This date cannot be earlier than the Mailing Date or the  accutrace_in_home_start_date.
         * This date defaults to +10 from the Mailing Date
         */
        public string        $accutrace_in_home_end_date = '',

        public string        $accutrace_segment_field_name = '',

        public string        $format = 'MIXED',

        public string        $list_owner_paf_id = '',

        /**
         * @var string This is the List owner information on the PAF (top section of form)
         * Each value is separated by a PIPE symbol in the following field order
         * company|address|city|state|zip+4|telephone|naics|email|name|title|MM/DD/YYYY (current date)
         */
        public string        $list_owner_information = '',

        /**
         * @var string 1=Exclude; 0 or Missing = Include: Moved - COA Matches
         */
        public string        $filter_ncoa_01 = '0',

        /**
         * @var string 1=Exclude; 0 or Missing = Include: Moved - New Address cannot be confirmed
         */
        public string        $filter_ncoa_02 = '0',

        /**
         * @var string 1=Exclude; 0 or Missing = Include: Moved - Left No Forwarding
         */
        public string        $filter_ncoa_03 = '0',

        /**
         * @var string 1=Exclude; 0 or Missing = Include: Moved - Foreign Country
         */
        public string        $filter_ncoa_04 = '0',

        /**
         * @var string 1=Exclude; 0 or Missing = Include: Moved - New State
         */
        public string        $filter_ncoa_05 = '0',

        /**
         * @var string 1=Exclude; 0 or Missing = Include: Individual Match
         */
        public string        $filter_ncoa_06 = '0',

        /**
         * @var string 1=Exclude; 0 or Missing = Include: Family Match
         */
        public string        $filter_ncoa_07 = '0',

        /**
         * @var string 1=Exclude; 0 or Missing = Include: Business Match
         */
        public string        $filter_ncoa_08 = '0',

        /**
         * @var string 1=Exclude; 0 or Missing = Include: Unit number provided but not verified
         */
        public string        $filter_cass_02 = '0',

        /**
         * @var string 1=Exclude; 0 or Missing = Include: Unit number missing from known high-rise address
         */
        public string        $filter_cass_03 = '0',

        /**
         * @var string 1=Exclude; 0 or Missing = Include: Vacant
         */
        public string        $filter_cass_04 = '0',

        /**
         * @var string 1=Exclude; 0 or Missing = Include: Business address
         */
        public string        $filter_cass_05 = '0',

        /**
         * @var string 1=Exclude; 0 or Missing = Include: Private Mail Box address
         */
        public string        $filter_cass_06 = '0',

        /**
         * @var string 1=Exclude; 0 or Missing = Include: Address not valid
         */
        public string        $filter_cass_07 = '0',

        /**
         * @var string 1=Exclude; 0 or Missing = Include: Missing address element(s)
         */
        public string        $filter_cass_08 = '0',

        /**
         * @var string 1=Exclude; 0 or Missing = Include: Foreign
         */
        public string        $filter_cass_09 = '0',

        /**
         * @var string 1=Exclude; 0 or Missing = Include: Military Addresses
         */
        public string        $filter_cass_10 = '0',

        /**
         * @var string States listed in filter_states will be EXCLUDED from the final production output file.
         */
        public string        $filter_states = '',

        /**
         * @var string Exports the file in North-South Order so you can print 2-up to 20-up and Stack and Cut without collating.
         */
        public string        $northsouth = '',

        /**
         * @var string The exported clean file type is CSV.
         * If you want dBase, then add this JSON object to the JSON structure in your PUT call.
         *
         * Leaving our this JSON obect and the clean data will be written as comma separated.
         */
        public string        $presort_output_type = 'csv',

        /**
         * @var string Gives you the flexibility to output other fields from the resulting process, such as
         * individual piece rates from the resulting presort, or the Delivery Point + Check Digit (dpc), etc.
         * A complete list of field names can be provided upon request.
         *
         * Important: For multiple field names, always separate each field name with a semicolon, e.g., dpc;vacant_
         */
        public string        $additional_output_fields = '',

        /**
         * @var string The value provide here will be inserted as-is before the default Endorsement
         * Line string, e.g., ***************AUTO 5-DIGIT 93422.  One (1) space will be added after
         * the value you enter.
         *
         * Possible Values: AUTO,PRESORTED
         */
        public string        $endorse_pretext = 'AUTO',

        /**
         * @var string The value should represent the exact spelling of a field you want to include as
         * part of the duplicate detection process.  For example, if you want the column name "job_id" as
         * part of the duplicate detection process, such as by Address or by Household, you would pass "job_id"
         * in this JSON object.
         */
        public string        $dups_additional_key1 = '',

        /**
         * @var string The value should represent the exact spelling of a field you want to include as part
         * of the duplicate detection process.  For example, if you want the column name "job_id" as part
         * of the duplicate detection process, such as by Address or by Household, you would pass "job_id"
         * in this JSON object.
         */
        public string        $dups_additional_key2 = '',

        /**
         * @var string 1=Only use 'dups_additional_key1' and if applicable 'dups_additional_key2' in duplicate
         * detection and do not use internal logic that includes the standardized address;
         * 0 or Missing = Include default duplicate detection logic (Best Practice)
         */
        public string        $dups_use_additional_keys_only = '',

        /**
         * @var string 00=Duplicate detection turned OFF
         * 01=Duplicates are detected by ADDRESS
         * 02=Duplicates are detected by FIRST AND LAST NAME
         * 03=Duplicates are detected by HOUSEHOLD NAME
         */
        public string        $dups = '00',

        /**
         * @var string "0=Default Name Match based on Last Name and First Initial
         * 1=Exact Name Match"
         */
        public string        $dups_exact_match = '0',

        /**
         * @var string 1=Turn On Canadian Address Correction; 0 or Missing = Turn Off Canadian Address Correction
         */
        public string        $canadian = '0',

        /**
         * @var string DO NOT MAIL indicator.
         * The value for "col_dnm" must be the name of the field in your database that contains the value "1" for
         * those records that you do not want to mail to.  This feature will DELETE the records where
         * the "col_dnm" field equals "1", along with any matching records BASED ON THE FIND DUPLICATES setting,
         * e.g., DUPS_01, DUPS_02 or DUPS_03.  If the Duplicate Detection is not used, then all of the Do Not Mail
         * records will be included in the resulting Presort.
         */
        public string        $col_dmn = '',

        /**
         * @var string By default, the contact information that is mapped to col_first is parsed into
         * separate fields, e.g., Sal First Middle Last.  If this value is set to =1, then the contact
         * information mapped to First remains untouched. Duplicate Detection will not be as accurate when
         * parse_first_name_off = 1.  The field mapped to col_last, i.e., the Last Name, if in a separate field
         * from the contact information, will not be included in the final print ready file.
         */
        public string        $parse_first_name_off = '1',

        /**
         * @var string UAA represents: Match – Foreign Move;
         * Match – Moved Left No Address; and Match – PO Box Closed.
         * Set 'uaa_flag_only' to 1 and the CASS Certified Address will not be changed to a UAA value.
         *
         * Only the following fields will be updated ffapplied_; matchflag_; movedate_; movetype_; nxi_; ank_.
         *
         * The standardized address fields will be left untouched.
         *
         * CAUTION: If you set uaa_flag_only to 1, then it is highly recommended that you sent the contact
         * name to CURRENT RESIDENT or you could lose your Full-Service Discount or get your mailing rejected.
         */
        public string        $uaa_flag_only = '',

        /**
         * @var string COA represents: A match to a Move in the NCOALink data that would change the original
         * address to the new address. Set 'coa_flag_only' to 1 and the CASS Certified Address will not be
         * changed to a COA value.
         *
         * Only the following fields will be updated ffapplied_; matchflag_; movedate_; movetype_; nxi_; ank_.
         *
         * The standardized address fields will be left untouched.
         */
        public string        $coa_flag_only = '0',

        /**
         * @var string 1=Include Container Tags TXT file; 0=Do not include Container Tags file.
         *
         * Column descriptions:
         * • Container Label - Line 1
         * • Container Label - Line 2
         * • Container Label - Line 3
         * • Tray# & Total Pieces In Tray & Number of Bundles (if Applicable) & Contianer Type
         * • Barcode String
         * • Database Name
         * • Full Barcode String
         * • AUTO or blank
         */
        public string        $presort_include_tags = '1',

        /**
         * @var string Mailers Information Area printed on Container Tags
         */
        public string        $user_information_line_1 = '',

        /**
         * @var string 1 = Off; 0 = On (if NCOA or CASS-NCOA-DUPS-PRESORT is passed as Parameter in Web Service call)
         */
        public string        $ncoalink_off = '',

        /**
         * @var string 1 = Off; 0 or missing = On
         */
        public string        $presort_off = '',

        /**
         * @var string 1 = Presort only Residential Address Types (EDDM) 0 = Presort both All Possible Address Types (EDDM).
         *
         * By default, if this JSON object is missing, All Possible Address Types (EDDM) will be presorted.
         */
        public string        $residential_only = '',

        /**
         * @var string 1=Yes; 0 or Missing = No
         */
        public string        $pdf_embed_fonts = '',

        /**
         * @var string 1=Yes; 0 or Missing = No
         */
        public string        $print_tag_summary = '',

        /**
         * @var string 1=Replicate the Seed Record, if a valid address, the minimum number of times to meet the
         * minimum presort discount threshold ; 0 or Missing = Ignore the seed record information
         */
        public string        $seed_option = '',

        /**
         * @var string First Name associated with the Seed record
         */
        public string        $seed_first = '',

        /**
         * @var string Last Name associated with the Seed record
         */
        public string        $seed_last = '',

        /**
         * @var string Company Name associated with the Seed record
         */
        public string        $seed_company = '',

        /**
         * @var string Address associated with the Seed record
         */
        public string        $seed_address = '',

        /**
         * @var string ZIP Code associated with the Seed record
         */
        public string        $seed_zip = '',

        /**
         * @var string 1 = Turns off the creation of the creation of the *.json file.  This should only be used if
         * you are only processing through our NCOALink feature alone where the GET call to process the list is 'NCOA'.
         * Do not set this value to 1 if you are going to PRESORT the list after processing through NCOA.
         * For large lists, this will increase the speed of the entire process significantly as JSON files
         * can be rather large.
         *
         * 0 or missing = By default, the *.json will be created
         */
        public string        $json_export_off = '',

        /**
         * @var string 1 = Turns off EDDM Retail qualification; 0 or missing will qualify list for
         * EDDM Retail if there are fewer than 5,000 records in EDDM database
         */
        public string        $eddm_retail_off = '',

        /**
         * @var string 1=Yes; 0 or Missing = No.
         * Requires DES Credits.
         * To add and link DES Credits to your API Key, please contact AccuZIP Inc. at 800-233-0555.
         */
        public string        $des_deceased = '',

        /**
         * @var string 1=Yes; 0 or Missing = No.
         * Requires DES Credits.
         * To add and link DES Credits to your API Key, please contact AccuZIP Inc. at 800-233-0555.
         */
        public string        $des_apartment = '',

        /**
         * @var string 1=Yes; 0 or Missing = No.
         * Requires DES Credits.
         * To add and link DES Credits to your API Key, please contact AccuZIP Inc. at 800-233-0555.
         */
        public string        $des_acoa = '',

        /**
         * @var string 1=Yes; 0 or Missing = No.
         * Requires DES Credits.
         * To add and link DES Credits to your API Key, please contact AccuZIP Inc. at 800-233-0555.
         */
        public string        $des_dsf2 = '',

        /**
         * @var string This number represents a percentage.  "9" would represent 9%, "9.7" would represent 9.7%.
         * This percent represents the minimum threshold required to process the mailing list through our
         * Data Enhancement Services (DES) DSF2 service.  When this threshold percentage is met, only those
         * records will be sent to the DES DSF2 service for processing.  For example, if your mailing list
         * contained 1,000 records and the "des_dsf2_threshold" value was "10", there would need to be a
         * minimum of 100 records that would qualify for the High Density (or better) discount.
         * If the minimum threshold is met or exceeded, only those eligible records would be sent to the
         * DES DSF2 process--meaning DES credits are only decremented for that selection of
         * records (100 instead of 1,000 credits, using the prior example).
         *
         * Note: This feature will be ignored if des_deceased or des_apartment or des_acoa setting is equal to "1"
         */
        public string        $des_dsf2_threshold = '',

        /**
         * @var string 1=Yes; 0 or Missing = No
         */
        public string        $des_deceased_include = '',

        /**
         * @var string 1=Yes; 0 or Missing = No
         */
        public string        $des_ignore_middle_name_and_secondary = '',

        /**
         * @var string 1 = Include Hard Copy Package Report; 0 or Missing = Do not include Hard Copy Package Report
         */
        public string        $print_package_report = '',

        /**
         * @var string 1 = Turn Off Optimize to keep list in same order after CASS or NCOA.
         * This has no impact on Presort; 0 or Missing = Optimize data is on to improve performance
         */
        public string        $optimize_off = '',

        /**
         * @var string  Salutation, e.g., Mr, Mrs, Dr, etc... Default Header Value in File if JSON value is empty
         */
        public string        $col_sal = '',

        /**
         * @var string Contacts first name
         */
        public string        $col_first = '',

        /**
         * @var string Contacts middle name or initial
         */
        public string        $col_middle = '',

        /**
         * @var string Contacts last name
         */
        public string        $col_last = '',

        /**
         * @var string Contacts title, e.g., President, Owner
         */
        public string        $col_title = '',

        /**
         * @var string Company or firm name
         */
        public string        $col_company = '',

        /**
         * @var string Primary address line
         */
        public string        $col_address = '',

        /**
         * @var string Secondary address, e.g., Ste, Apt, etc...
         */
        public string        $col_address2 = '',

        /**
         * @var string Auxiliary address information
         */
        public string        $col_address3 = '',

        /**
         * @var string Auxiliary address information
         */
        public string        $col_address4 = '',

        /**
         * @var string Auxiliary address information
         */
        public string        $col_address5 = '',

        /**
         * @var string Auxiliary address information
         */
        public string        $col_address6 = '',

        /**
         * @var string Auxiliary address information
         */
        public string        $col_address7 = '',

        /**
         * @var string Auxiliary address information
         */
        public string        $col_address8 = '',

        /**
         * @var string Auxiliary address information
         */
        public string        $col_address9 = '',

        /**
         * @var string Auxiliary address information
         */
        public string        $col_address10 = '',

        /**
         * @var string  City name
         */
        public string        $col_city = '',

        /**
         * @var string A 2-character abbreviation for the name of a state,
         * U.S. territory, or armed forces ZIP Code designation.
         *
         * If Army/Air Force (APO), Fleet Post Office (FPO), or Diplomatic/Defense Post Office (DPO),
         * then the state abbreviation will be “AA,” “AE,” or “AP.”
         */
        public string        $col_st = '',

        /**
         * @var string ZIP Code: A 5-digit code that identifies a specific geographic delivery area.
         * ZIP Codes can represent an area within a state, or a single building or company that
         * has a very high mail volume.
         */
        public string        $col_zip = '',

        /**
         * @var string Urbanization for Puerto Rico addresses
         */
        public string        $col_urban = '',

        /**
         * @var string Country of origin. Canadian addresses are supported.
         * Only address records where 'CA' or 'CANADA' appears in the field mapped to col_country will be
         * processed through the Canadian Address verification.
         */
        public string        $col_country = '',

        /**
         * @var string Walk sequence number for saturation mailings
         */
        public string        $col_walkseq_ = '',

        /**
         * @var string E-Mail address
         */
        public string        $col_email = '',

        /**
         * @var string Primary or business phone number
         */
        public string        $col_phone1 = '',

        /**
         * @var string Secondary or fax phone number
         */
        public string        $col_phone2 = '',

        /**
         * @var string Home phone number
         */
        public string        $col_phone3 = '',

        /**
         * @var string ACS unique keyline used with ACS
         */
        public string        $col_acs_key = '',

        /**
         * @var string ACS participation code assigned by USPS
         */
        public string        $col_acs_part = '',

        /**
         * @var string Can contain any data the user would like to use to identify the mail piece in AccuTrace
         */
        public string        $col_userpcid = '',

        /**
         * @var string Can contain one or more email and or cell phone numbers.
         * Each entry should be separated with a semicolon, e.g., email1@dot.com;email2@dot.com;+18054617300
         */
        public string        $col_userpctxt = '',

        /**
         * @var string Can contain a redirect URL for use with QR code that is generated by AccuTrace.
         * When the customer scans the QR code that is printed on the mail piece, they will be directed to this URL
         */
        public string        $col_userpcurl = '',

        /**
         * @var string Website URL address
         */
        public string        $col_website = '',

        /**
         * @var string Complete delivery point barcode string
         */
        public string        $col_barcode = '',

        /**
         * @var string Intelligent Mail Barcode 65-Character String
         */
        public string        $col_imbarcode = '',

        /**
         * @var string First 20-Characters that make up the IMB
         */
        public string        $col_imbdigits = '',

        /**
         * @var string Intelligent Mail Package Barcode
         */
        public string        $col_impb_ = '',

        /**
         * @var string User Defined Serial Number
         */
        public string        $col_usersrl_ = '',

        /**
         * @var string User Defined Mailer ID
         */
        public string        $col_usermid_ = '',

        /**
         * @var string User Defined Service Type
         */
        public string $col_userstid_ = '',

        /**
         * @var string User Defined Barcode ID
         */
        public string        $col_userbarid_ = '',

        /**
         * @var string Primary Street Number or PO Box Number
         */
        public string        $col_primary_ = '',

        /**
         * @var string "Street Pre-Directional Abbreviation: A geographic direction that precedes the street name, such as:
         * E = East
         * N = North
         * NE = Northeast
         * NW = Northwest
         * Blank = No pre-direction"
         */
        public string        $col_pre_ = '',

        /**
         * @var string Street Name: The official name of a street as assigned by a local governing authority.
         * The Street Name field contains only the street name and does not include directionals (EAST, WEST, etc.) or
         * suffixes (ST, DR, BLVD, etc.).
         *
         * This element may also contain literals, such as PO BOX, GENERAL DELIVERY, USS, PSC, or UNIT.
         */
        public string        $col_street_ = '',

        /**
         * @var string Street Suffix Abbreviation: Code that is the standard USPS® abbreviation for the
         * trailing designator (i.e., street type) in a street address.
         *
         * Example: Central Street or Valley Circle (See USPS Publication 28, Postal Addressing Standards, for values)
         */
        public string        $col_suffix_ = '',

        /**
         * @var string Street Post-Directional Abbreviation: A geographic direction that follows the street name, such as:
         * E = East
         * N = North
         * NE = Northeast
         * NW = Northwest
         * Blank = No post-direction
         */
        public string        $col_post_ = '',

        /**
         * @var string Suite or Apartment name, e.g., APT, STE, etc.
         */
        public string        $col_abrev_ = '',

        /**
         * @var string Suite or Apartment number
         */
        public string        $col_secy_ = '',

        /**
         * @var string Private Mailbox indicator, e.g., PMB
         */
        public string        $col_pmb_ = '',

        /**
         * @var string Private Mailbox Number
         */
        public string        $col_pmbno_ = '',

        /**
         * @var string 5-digit portion of ZIP+4
         */
        public string        $col_zip5 = '',

        /**
         * @var string Plus4 Code: In a +4 code, the 4-digit number that follows the 5-digit ZIP Code.
         *
         * The 4-digit ZIP add-on further subdivides these areas.
         */
        public string        $col_zip4 = '',

        /**
         * @var string 2-digit Delivery Point and Check digit for barcode
         */
        public string        $col_dpc = '',

        /**
         * @var string 2-digit delivery point code
         */
        public string        $col_dp = '',

        /**
         * @var string The check digit for DPBC or 5-digit barcode
         */
        public string        $col_chkdg = '',

        /**
         * @var string Delivery Point Validation
         */
        public string        $col_dpv_ = '',

        /**
         * @var string DPV Foot Notes
         */
        public string        $col_dpvnotes_ = '',

        /**
         * @var string Carrier Route ID: A 4-character code assigned to a mail delivery or collection route within a
         * 5-digit ZIP Code.
         *
         * The first character of this identification is alphabetical, and the last three are numeric:
         * B### = PO Box
         * H### = Contract
         * R### = Rural route
         * C### = City delivery
         * G### = General delivery
         */
        public string        $col_crrt = '',

        /**
         * @var string Line of travel order
         */
        public string        $col_ascdesc_ = '',

        /**
         * @var string The Federal Information Processing Standard (FIPS) code assigned to a given county or
         * parish within a state. In Alaska, it identifies a region within the state.
         * If APO/FPO/DPO, and the record type is “S,” “H,” or “F,” the county number will be blank.
         */
        public string        $col_countyno_ = '',

        /**
         * @var string County name
         */
        public string        $col_countynm_ = '',

        /**
         * @var string A standard value identifying a geographic area within the United States served by a
         * member of the U.S. House of Representatives. If APO/FPO/DPO, this field will be blank.
         * If there is only one member of Congress within a state, the code will be “AL” (at large).
         */
        public string        $col_congress_ = '',

        /**
         * @var string Area code for address
         */
        public string        $col_area_ = '',

        /**
         * @var string Indicates if the address is Vacant
         */
        public string        $col_vacant_ = '',

        /**
         * @var string The Locatable Address Conversion Service (LACS) indicator describes records that have been
         * converted to the LACS system (a product/system in a different USPS product line that allows mailers to
         * identify and convert a rural route address to a city-style address). Rural route and some city addresses
         * are being modified to city-style addresses so that emergency services (e.g., ambulances, police) can find
         * these addresses more efficiently.
         * L = LACS address: The old (usually rural-route) address that has been converted for the LACS system.
         * Blank = Not applicable
         */
        public string        $col_lacs_ = '',

        /**
         * @var string LACSLink Indicator
         */
        public string        $col_lacsind_ = '',

        /**
         * @var string LACSLink Return Code
         */
        public string        $col_lacsrc_ = '',

        /**
         * @var string code assigned to Postal Service™ facilities (primarily Post Offices) to collect cost and
         * statistical data and compile revenue and expense data. The finance number can be used to match to
         * records in other USPS files. By sorting these files by finance number, sequence matches can be made
         * to use other street-level address information. For example, to use ZIP+4 product to obtain ZIP+4
         * codes for street addresses, a 5-digit ZIP Code, last-line number, or finance number for the street
         * address must be known. The finance number can be obtained from the USPS City State product.
         * For a street address such as “123 MAIN ST, SAN FRANCISCO CA,” matching to the City State product
         * will not provide a single 5-digit ZIP Code because San Francisco has more than one
         * ZIP Code (i.e., it is a “multi-coded city”); However, the finance number for San Francisco can be
         * obtained from the City State product. Then, by sorting the ZIP+4 product into finance number
         * and street-name sequence, a match can be found to provide both the correct 5-digit ZIP Code and ZIP+4 code.
         */
        public string        $col_financeno_ = '',

        /**
         * @var string Leftout or unused address information
         */
        public string        $col_leftout_ = '',

        /**
         * @var string Line of travel number
         */
        public string        $col_lot_ = '',

        /**
         * @var string SuiteLink Indicator
         */
        public string        $col_stelink_ = '',

        /**
         * @var string State Code
         */
        public string        $col_stno_ = '',

        /**
         * @var string Deliverability status, e.g., V, N, M or blank
         */
        public string        $col_status_ = '',

        /**
         * @var string Record Type: An alphabetic value that identifies the type of data in the record.
         *
         * Record type codes include the following:
         * G = General delivery
         * H = High-rise
         * F = Firm
         * S = Street
         * P = PO Box
         * R = Rural route/contract
         */
        public string        $col_type_ = '',

        /**
         * @var string Used to duplicate the original address
         */
        public string        $col_oaddress = '',

        /**
         * @var string Used to duplicate the original city
         */
        public string        $col_ocity = '',

        /**
         * @var string Original input company name mapped to col_company
         */
        public string        $col_ocompany = '',

        /**
         * @var string Used to duplicate the original state
         */
        public string        $col_ostate = '',

        /**
         * @var string Used to duplicate the original zip
         */
        public string        $col_zipcode = '',

        /**
         * @var string Time Zone for address
         */
        public string        $col_otimezone_ = '',

        /**
         * @var string Error and warning codes
         */
        public string        $col_errno_ = '',

        /**
         * @var string Any value, e.g., 1 or Yes or any other value in this field indicates this record is a Seed Record.
         * If empty, it is treated as a normal record.  Seed records are not suppressed from the database and will
         * always be included in the resulting output file and presort.
         */
        public string        $col_seed = '',

        /**
         * @var string Date NCOALink processing occurred
         */
        public string        $col_ffapplied_ = '',

        /**
         * @var string Match Flag, e.g., Moved, PO Box Closed, etc..
         */
        public string        $col_matchflag_ = '',

        /**
         * @var string Move Date
         */
        public string        $col_movedate_ = '',

        /**
         * @var string Move Type, e.g., Business, Family, Individual
         */
        public string        $col_movetype_ = '',

        /**
         * @var string Nixie Code
         */
        public string        $col_nxi_ = '',

        /**
         * @var string ANKLink Match Flag
         */
        public string        $col_ank_ = '',

        /**
         * @var string Centroid Latitude: Latitude of the ZIP+4 address range centroid
         */
        public string        $col_elatitude = '',

        /**
         * @var string Centroid Longitude: Longitude of the ZIP+4 address range centroid
         */
        public string        $col_elongitude = '',

        /**
         * @var string A census block group is a cluster of census blocks represented by a
         * code that includes state, county, and tract codes.
         */
        public string        $col_census_bl = '',

        /**
         * @var string Census Match Code: 0 = No Match; 4 = Parcel Geopoint Match
         */
        public string        $col_census_rs = '',

        /**
         * @var string Census Track Number
         */
        public string        $col_census_tr = '',

        /**
         * @var string Latitude for 5-Digit ZIP Code Centroid
         */
        public string        $col_latitude_ = '',

        /**
         * @var string Longitude for input address
         */
        public string        $col_longitude_ = '',

        /**
         * @var string DSF2 Address Type Indicator
         */
        public string        $col_dsf_adrtyp = '',

        /**
         * @var string DSF2 Business Indicator
         */
        public string        $col_dsf_busind = '',

        /**
         * @var string DSF2 Delivery Type Code
         */
        public string        $col_dsf_deltyp = '',

        /**
         * @var string DSF2 Drop Count
         */
        public string        $col_dsf_dropct = '',

        /**
         * @var string DSF2 Drop Indicator
         */
        public string        $col_dsf_dropin = '',

        /**
         * @var string DSF2 Education Seasonality Code
         */
        public string        $col_dsf_edutyp = '',

        /**
         * @var string DSF LACSLink Indicator
         */
        public string        $col_dsf_lacsin = '',

        /**
         * @var string DSF2 No Stats Indicator
         */
        public string        $col_dsf_nostat = '',

        /**
         * @var string DSF2 Primary Number Error
         */
        public string        $col_dsf_prierr = '',

        /**
         * @var string DSF2 Seasonal Indicator
         */
        public string        $col_dsf_seasnl = '',

        /**
         * @var string DSF2 Secondary Number Error
         */
        public string        $col_dsf_secerr = '',

        /**
         * @var string DSF2 Throwback Indicator
         */
        public string        $col_dsf_thback = '',

        /**
         * @var string Presort Sequence Number
         */
        public string        $col_sequence = '',

        /**
         * @var string Endorsement line: Printed on each mail-piece to identify the contents of a tray, sack or bundle.
         */
        public string        $col_endorse = '',

        /**
         * @var string Pallet number
         */
        public string        $col_pallet_id = '',

        /**
         * @var string Container number
         */
        public string        $col_cont_id = '',

        /**
         * @var string Container Type - 1=1' Foot; 2=2'Foot; T=Tub; S=Sack
         */
        public string        $col_cont_type = '',

        /**
         * @var string Group number for automation Letters in trays or Bundle number bundle based mail preparation
         */
        public string        $col_gpb_id = '',

        /**
         * @var string Postage rate for individual mail-piece
         */
        public string        $col_rate_ = '',

        /**
         * @var string Rate Code for individual mail-piece, e.g., 5B, 3B
         */
        public string        $col_ratecode_ = '',

        /**
         * @var string Tray Mark when tray changes, e.g., **
         */
        public string        $col_traymark_ = '',

        /**
         * @var string ACS Keyline
         */
        public string        $col_keyline = '',

        /**
         * @var string IMb 31-Digits (Intelligent Mail barcode)
         */
        public string        $col_imb31 = '',

        /**
         * @var string Placard 99M Digits
         */
        public string        $col_pallbar99m = '',

        /**
         * @var string Container 24-Digit Barcode
         */
        public string        $col_contbar24 = '',

        /**
         * @var string IMpb Human Readable Barcode
         */
        public string        $col_impb26 = '',

        /**
         * @var string Deceased Flagging Data
         */
        public string        $col_dfl_ = '',

        /**
         * @var string DFL Return Code
         */
        public string        $col_dflcode_ = '',

        /**
         * @var string Deceased Date of Death
         */
        public string        $col_dfldate_ = '',

        /**
         * @var string ACOA Deliverability Code: ACOA list processing through compiled data containing
         * proprietary COA’s from retail, publishing, telecom, utility companies
         */
        public string        $col_acoa_ = '',

        /**
         * @var string ACOA Move Effective Date
         */
        public string        $col_acoadate_ = '',

        /**
         * @var string ACOA New Address Level of Match
         */
        public string        $col_acoalevel_ = '',

        /**
         * @var string ACOA Nixie Codes
         */
        public string        $col_acoaxl_ = '',

        /**
         * @var string ACOA Additional Match Codes
         */
        public string        $col_acoatype_ = '',

        /**
         * @var string Apartment Number Code
         */
        public string        $col_abrcd = '',

        /**
         * @var string Unit Designator Code
         */
        public string        $col_unitcd = '',

        /**
         * @var string Provide as decimal value in Inches, e.g., 0.042
         */
        public string        $col_piece_thickness = '',

        /**
         * @var string Provide as decimal value in Inches, e.g., 0.1683
         */
        public string        $col_piece_lb = '',

        /**
         * @var string Provide a number from 1 to 999 to identify the Mail Owner
         */
        public string        $col_customer_code = '',

        /**
         * @var string Permit Payment Method or 'Permit Number'. Use P or S or M.  P=Permit Imprint; S=Stamp; M=Meter
         */
        public string        $col_payment_method = '',

        /**
         * @var string Use this column to provide the exact postage amount you are applying to the mail piece, e.g., 0.352.
         * This would represent 35.2 cents.
         */
        public string        $col_affixed_postage = '',

        /**
         * @var string CRID of Mail Owner.  6- or 9- Digit
         */
        public string        $col_crid_of_mail_owner = '',

        /**
         * @var string MID of Mail Owner.  6- or 9- Digit
         */
        public string        $col_mid_of_mail_owner = '',

        /**
         * @var string Permit Number of 'CRID of Mail Owner' or MID of Mail Owner'
         */
        public string        $col_permit_no = '',

        /**
         * @var string Permit ZIP+4 of 'Permit Number'
         */
        public string        $col_permit_zip = '',

    )
    {
    }
}




