<?php

namespace Ptb\Accuzip\Requests\CASS;

use Ptb\Accuzip\Enums\TaskType;
use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

class DoCertification extends Request implements HasBody
{
    use HasJsonBody;

    /**
     * Define the HTTP method
     *
     * @var Method
     */
    protected Method $method = Method::GET;

    /**
     * Define the endpoint for the request
     *
     * @return string
     */
    public function resolveEndpoint(): string
    {
        return "/servoy-service/rest_ws/ws_360/v2_0/job/{$this->guid}/CASS";
    }

    /**
     * Use this web service call to clean and standardize all of the addresses in the file. This web service call must be
     * called after the file has been uploaded successfully and before the NCOALink, Duplicate Detection or Presort
     * web service calls.
     *
     * @param string $guid
     */
    public function __construct(
        private readonly string $guid,
    )
    {}
}
