<?php

namespace Ptb\Accuzip\Enums\QUOTE;

enum TrayType: string
{
    case Flat = '0MM';
    case OneFtManagedMail = '1MM';
    case TwoFtManagedMail = '2MM';
    case TwoFtExtended = 'EMM';
    case TwoFtExtended1FootManagedMail = 'EM1';
    
public function description(): string
    {
        return match($this) {
            TrayType::Flat => 'Flat',
            TrayType::OneFtManagedMail => '1ft Managed Mail',
            TrayType::TwoFtManagedMail => '2ft Managed Mail',
            TrayType::TwoFtExtended => '2ft Extended',
            TrayType::TwoFtExtended1FootManagedMail => '2ft Extended Managed Mail',
        };
    }

    public static function toArray(): array
    {
        return [
            TrayType::Flat->value => 'Flat',
            TrayType::OneFtManagedMail->value => '1ft Managed Mail',
            TrayType::TwoFtManagedMail->value => '2ft Managed Mail',
            TrayType::TwoFtExtended->value => '2ft Extended',
            TrayType::TwoFtExtended1FootManagedMail->value => '2ft Extended Managed Mail',
        ];
    }        
}