<?php

namespace Ptb\Accuzip;

use Saloon\Http\Request;
use Saloon\Http\Connector;
use Saloon\Traits\Plugins\AcceptsJson;

class AccuzipConnector extends Connector
{
    use AcceptsJson;

    protected array $cookies = [];

    /**
     * The Base URL of the API
     *
     * @return string
     */
    public function resolveBaseUrl(): string
    {
        return 'https://cloud2.iaccutrace.com';
    }

    public function defaultConfig(): array
    {
        return [
            'timeout' => 300,
            'connect_timeout' => 15,
        ];
    }

    /**
     * @param Request $request
     * @return array
     */
    public function getUrlForRequest(Request $request): array
    {
        return [
            "{$this->resolveBaseUrl()}{$request->resolveEndpoint()}",
            $request->query(),
        ];
    }
}
