<?php

namespace Ptb\Accuzip\Requests\CASS;

use Ptb\Accuzip\Enums\CASS\FilterSubType;
use Ptb\Accuzip\Enums\FilterDuplicates;
use Ptb\Accuzip\Enums\TaskType;
use Ptb\Accuzip\Models\Task;
use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

class GetCertifiedRecords extends Request implements HasBody
{
    use HasJsonBody;

    /**
     * Define the HTTP method
     *
     * @var Method
     */
    protected Method $method = Method::GET;

    /**
     * Define the endpoint for the request
     *
     * @return string
     */
    public function resolveEndpoint(): string
    {
        return "/servoy-service/rest_ws/ws_360/v2_0/job/{$this->guid}/CleanAddresses/{$this->filterSubType}";
    }

    private int $filterSubType;

    /**
     * @param FilterSubType $filter
     * @return $this
     */
    public function withFilter(FilterSubType $filter): static
    {
        $this->filterSubType = $filter->value;

        return $this;
    }

    /**
     * Use this web service call to retrieve certain types of CASS Certified records to display in a grid for the user to
     * review and edit if necessary.
     *
     * @param string $guid
     */
    public function __construct(
        private readonly string $guid,
    )
    {}
}
