<?php

namespace Ptb\Accuzip\Requests\NCOA;

use Ptb\Accuzip\Enums\TaskType;
use Saloon\Enums\Method;
use Saloon\Http\Request;

class DoCertification extends Request
{
    /**
     * Define the HTTP method
     *
     * @var Method
     */
    protected Method $method = Method::GET;

    /**
     * Define the endpoint for the request
     *
     * @return string
     */
    public function resolveEndpoint(): string
    {
        return "/servoy-service/rest_ws/ws_360/v2_0/job/{$this->guid}/NCOA";
    }

    /**
     * Use this web service call to process the names and addresses that have been previously CASS Certified,
     * through our Licensed NCOALink process for Change of Address matching. Prior to processing any Mailing List
     * through our Licensed NCOALink AccuZIP Inc. must have a fully executed Processing Acknowledgment Form (PAF)
     * on file for each List Owner submitting a Mailing List.
     *
     * @param string $guid
     */
    public function __construct(
        private readonly string $guid,
    )
    {}
}
