<?php

namespace Ptb\Accuzip\Requests\QUOTE;

use Ptb\Accuzip\Enums\TaskType;
use Saloon\Enums\Method;
use Saloon\Http\Request;

class GetQuote extends Request
{
    /**
     * Define the HTTP method
     *
     * @var Method
     */
    protected Method $method = Method::GET;

    /**
     * Define the endpoint for the request
     *
     * @return string
     */
    public function resolveEndpoint(): string
    {
        return "/servoy-service/rest_ws/ws_360/v2_0/job/{$this->guid}/QUOTE";
    }

    /**
     * Use this web service call after a file has been uploaded to our Cloud. This GET web service call will return a
     * quote for the approximate postage amount the user will save vs. what they would have paid if they did not
     * clean, standardize and presort their list.
     *
     * @param string $guid
     */
    public function __construct(
        private readonly string $guid,
    )
    {}
}
