<?php

namespace Ptb\Accuzip\Requests\ACCOUNT;

use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

class GetAccount extends Request implements HasBody
{
    use HasJsonBody;

    /**
     * Define the HTTP method
     *
     * @var Method
     */
    protected Method $method = Method::POST;

    /**
     * Define the endpoint for the request
     *
     * @return string
     */
    public function resolveEndpoint(): string
    {
        return '/servoy-service/rest_ws/ws_360/v2_0/INFO';
    }

    /**
     * Define the default body for the request
     *
     * @return array
     */
    public function defaultBody(): array
    {
        return [
            'apiKey' => config('accuzip.key'),
        ];
    }
}
