<?php

namespace Ptb\Accuzip\Enums\QUOTE;

enum PresortClass: string
{
    case FirstClass = 'FIRST CLASS';
    case Periodicals = 'PERIODICALS';
    case StandardMail = 'STANDARD MAIL';
    case StandardMailEDDM = 'STANDARD MAIL (EDDM)';
    case BoundPrintedMatter = 'BOUND PRINTED MATTER';
    case MediaMail = 'MEDIA MAIL';
    case LibraryMail = 'LIBRARY MAIL';

    public function description(): string
    {
        return match($this) {
            PresortClass::FirstClass => 'First Class',
            PresortClass::Periodicals => 'Periodicals',
            PresortClass::StandardMail => 'Standard Mail',
            PresortClass::StandardMailEDDM => 'Standard Mail (EDDM)',
            PresortClass::BoundPrintedMatter => 'Bound Printed Matter',
            PresortClass::MediaMail => 'Media Mail',
            PresortClass::LibraryMail => 'Library Mail',
        };
    }

    public static function toArray(): array
    {
        return [
            PresortClass::FirstClass->value => PresortClass::FirstClass->description(),
            PresortClass::Periodicals->value => PresortClass::Periodicals->description(),
            PresortClass::StandardMail->value => PresortClass::StandardMail->description(),
            PresortClass::StandardMailEDDM->value => PresortClass::StandardMailEDDM->description(),
            PresortClass::BoundPrintedMatter->value => PresortClass::BoundPrintedMatter->description(),
            PresortClass::MediaMail->value => PresortClass::MediaMail->description(),
            PresortClass::LibraryMail->value => PresortClass::LibraryMail->description(),
        ];
    }
}