<?php

namespace Ptb\Accuzip\Jobs\PRESORT;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Ptb\Accuzip\AccuzipConnector;
use Ptb\Accuzip\Models\AccuzipQuote;
use Ptb\Accuzip\Requests\PRESORT\DoPresort;
use ReflectionException;
use Saloon\Exceptions\InvalidResponseClassException;
use Saloon\Exceptions\PendingRequestException;

class Process implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * @param AccuzipQuote $quote
     */
    public function __construct(
        private readonly AccuzipQuote $quote
    )
    {}

    /**
     * @param AccuzipConnector $service
     * @return void
     * @throws ReflectionException
     * @throws InvalidResponseClassException
     * @throws PendingRequestException
     */
    public function handle(
        AccuzipConnector $service,
    ): void
    {
        $response = $service->send(request: $this->buildPresortRequest());
        if ($response->failed()) {
            $response->throw();
        }
    }

    /**
     * @return DoPresort
     */
    protected function buildPresortRequest(): DoPresort
    {
        return new DoPresort(guid: $this->quote->guid);
    }
}
