<?php

namespace Ptb\Accuzip;

use Illuminate\Support\ServiceProvider;

class AccuzipServiceProvider extends ServiceProvider
{

    /**
     * Register any application services
     *
     * @return void
     */
    public function register(): void
    {

    }

    /**
     * Bootstrap any application services
     *
     * @return void
     */
    public function boot(): void
    {

        $this->mergeConfigFrom(
            path: __DIR__ . '/../config/accuzip.php',
            key: 'accuzip'
        );

        $this->publishes(
            paths: [
                __DIR__ . '/../config/accuzip.php' => config_path('accuzip.php'),
                __DIR__ . '/../database/migrations/**' => database_path('migrations'),
            ],
            groups: 'accuzip',
        );

        $this->loadRoutesFrom(
            path: __DIR__ . '/../routes/api.php'
        );

        $this->loadMigrationsFrom(
            paths: __DIR__ . '/../database/migrations'
        );
    }

    /**
     * Get the services provided by the provider
     *
     * @return string[]
     */
    public function provides(): array
    {
        return [

        ];
    }
}
