<?php

namespace Ptb\Accuzip\Data;

use DateTimeInterface;
use Ptb\Accuzip\Enums\QUOTE\MailPieceSize;
use Ptb\Accuzip\Enums\QUOTE\PresortClass;
use Ptb\Accuzip\Enums\QUOTE\TrayType;
use Spatie\LaravelData\Data;

class QuoteTemplateData extends Data
{
    public function __construct(
        public ?string            $name = null,
        public ?bool               $cassEnabled = true,
        public ?bool               $ncoaEnabled = true,
        public ?bool               $duplicatesEnabled = true,
        public ?bool               $presortEnabled = true,
        public ?PresortClass      $presortClass = null,
        public ?int               $dropZip = null,
        public ?MailPieceSize     $pieceSize = null,
        public ?string            $mailPermitNumber = null,
        public ?float             $pieceHeight = 0.0,
        public ?float             $pieceLength = 0.0,
        public ?float             $pieceThickness = 0.0,
        public ?float             $pieceWeight = 0.0,
        public ?TrayType          $trayType = null,
        public ?string            $min1ft = null,
        public ?string            $max1ft = null,
        public ?string            $min2ft = null,
        public ?string            $max2ft = null,
        public ?MailingAgentData  $mailingAgent = null,
        public ?PermitHolderData  $permitHolder = null,
        public ?PreparedForData   $preparedFor = null,
        public ?ColumnMapData     $columnMapping = null,
        public ?bool               $printBarcode = true,
        public ?bool               $printIMB = true,
        public ?bool               $printReverse = false,
        public ?string             $machinability = 'MACHINABLE',
        public ?string             $mailPermitType = 'PROFIT',
        public ?string             $mailPayMethod = 'IMPRINT',
        public ?bool               $includeNonZip4 = false,
        public ?bool               $includeCRRT = false,
        public ?bool               $politicalMail = false,
        public ?bool               $electionMail = false,
        public ?bool               $mailDatPDR = true,
        public ?bool               $coaFlagOnly = false,  //COA represents: A match to a Move in the NCOALink data that would change the original address to the new address. Set 'coa_flag_only' to 1 and the CASS Certified Address will not be changed to a COA value.  Only the following fields will be updated ffapplied_; matchflag_; movedate_; movetype_; nxi_; ank_.  The standardized address fields will be left untouched.
        public ?bool               $filterNCOA01 = false, //1=Exclude; 0 or Missing = Include: Moved - COA Matches
        public ?bool               $filterNCOA02 = false, //1=Exclude; 0 or Missing = Include: Moved - New Address cannot be confirmed
        public ?bool               $filterNCOA03 = false, //1=Exclude; 0 or Missing = Include: Moved - Left No Forwarding
        public ?bool               $filterNCOA04 = false, //1=Exclude; 0 or Missing = Include: Moved - Foreign Country
        public ?bool               $filterNCOA05 = false, //1=Exclude; 0 or Missing = Include: Moved - New State
        public ?bool               $filterNCOA06 = false, //1=Exclude; 0 or Missing = Include: Individual Match
        public ?bool               $filterNCOA07 = false, //1=Exclude; 0 or Missing = Include: Family Match
        public ?bool               $filterNCOA08 = false, //1=Exclude; 0 or Missing = Include: Business Match
        public ?bool               $filterCASS02 = false, //1=Exclude; 0 or Missing = Include: Unit number provided but not verified
        public ?bool               $filterCASS03 = false, //1=Exclude; 0 or Missing = Include: Unit number missing from known high-rise address
        public ?bool               $filterCASS04 = false, //1=Exclude; 0 or Missing = Include: Vacant
        public ?bool               $filterCASS05 = false, //1=Exclude; 0 or Missing = Include: Business address
        public ?bool               $filterCASS06 = false, //1=Exclude; 0 or Missing = Include: Private Mail Box address
        public ?bool               $filterCASS07 = false, //1=Exclude; 0 or Missing = Include: Address not valid
        public ?bool               $filterCASS08 = false, //1=Exclude; 0 or Missing = Include: Missing address element(s)
        public ?bool               $filterCASS09 = false, //1=Exclude; 0 or Missing = Include: Foreign
        public ?bool               $filterCASS10 = false, //1=Exclude; 0 or Missing = Include: Military Addresses
    )
    {
    }
}




