<?php

namespace Ptb\Accuzip\Requests\DUPS;

use Ptb\Accuzip\Enums\FilterDuplicates;
use Ptb\Accuzip\Enums\TaskType;
use Ptb\Accuzip\Models\Task;
use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

class GetDetectedRecords extends Request implements HasBody
{
    use HasJsonBody;

    /**
     * Define the HTTP method
     *
     * @var Method
     */
    protected Method $method = Method::GET;

    /**
     * Define the endpoint for the request
     *
     * @return string
     */
    public function resolveEndpoint(): string
    {
        return "/servoy-service/rest_ws/ws_360/v2_0/job/{$this->guid}/DUPLICATES/{$this->duplicateSubType}";
    }

    /**
     * Retrieve duplicates by Address and, if exists, Company
     *
     * @return $this
     */
    public function byAddressOnly(): static
    {
        $this->duplicateSubType = '01';

        return $this;
    }

    /**
     * Retrieve duplicates by First and Last Name
     *
     * @return $this
     */
    public function byFirstLast(): static
    {
        $this->duplicateSubType = '02';

        return $this;
    }

    /**
     * Retrieve duplicates by Household Name
     *
     * @return $this
     */
    public function byHousehold(): static
    {
        $this->duplicateSubType = '03';

        return $this;
    }

    /**
     * @var string
     */
    private string $duplicateSubType;

    /**
     * Use this web service call to retrieve the duplicate records found in the “Duplicate Detection” web service. It is
     * important to use the same <duplicateSubType> used in the “Duplicate Detection” web service call in order to
     * retrieve the matching records.
     *
     * @param string $guid
     */
    public function __construct(
        private readonly string $guid,
    )
    {}
}
