<?php

namespace Ptb\Accuzip\Nova;

use Laravel\Nova\Fields\Boolean;
use Laravel\Nova\Fields\HasMany;
use Laravel\Nova\Fields\KeyValue;
use Laravel\Nova\Fields\Number;
use Laravel\Nova\Fields\Select;
use Laravel\Nova\Fields\Text;
use Laravel\Nova\Http\Requests\NovaRequest;
use Laravel\Nova\Panel;
use Laravel\Nova\Resource;
use Ptb\Accuzip\Data\ColumnMapData;

class AccuzipTemplate extends Resource
{
    public static $group = 'Integrations';
    public static $model = \Ptb\Accuzip\Models\AccuzipTemplate::class;
    public static $title = 'description';
    public static $search = [
        'description'
    ];

    public function fields(NovaRequest $request)
    {
        return [
            Text::make('Description', 'description')
                ->required(),

            Select::make('Class')
                ->help("Class of Mail that will be used to qualify the postage rate and presort levels for the mail-pieces")
                ->options([
                'FIRST CLASS' => 'FIRST CLASS',
                'PERIODICALS' => 'PERIODICALS',
                'STANDARD MAIL' => 'STANDARD MAIL',
                'STANDARD MAIL (EDDM)' => 'STANDARD MAIL (EDDM)',
                'BOUND PRINTED MATTER' => 'BOUND PRINTED MATTER',
                'MEDIA MAIL' => 'MEDIA MAIL',
                'LIBRARY MAIL' => 'LIBRARY MAIL'
            ])
                ->required(),
            Text::make('Drop Zip', 'drop_zip')
                ->help("5-Digit ZIP Code of Entry Post Office (BMEU) where the mail is verified")
                ->required(),
            Boolean::make('CASS Enabled?', 'cass_enabled')->default(true)->hideFromIndex(),
            Boolean::make('NCOALink Enabled?', 'nco_enabled')->default(true)->hideFromIndex(),
            Boolean::make('Duplicate Detection Enabled?', 'duplicaed_enabled')
                    ->default(false)
                    ->hideFromIndex(),
//            Boolean::make('Presort Enabled?', 'do_presort')
//                ->default(true),

            Panel::make('Mail-Piece Information', [
                Select::make('Piece Size', 'piece_size')
                    ->options([
                    'CARD' => 'CARD',
                    'LETTER' => 'LETTER',
                    'FLAT' => 'FLAT',
                    'PARCEL' => 'PARCEL',
                    'MANIFEST CARD' => 'MANIFEST CARD',
                    'MANIFEST LETTER' => 'MANIFEST LETTER',
                    'MANIFEST FLAT' => 'MANIFEST FLAT'
                ])
                    ->required(),
                Number::make('Height', 'piece_height')
                    ->step(0.01)
                    ->required(),
                Number::make('Length', 'piece_length')
                    ->step(0.01)
                    ->required(),
                Number::make('Thickness', 'piece_thickness')
                    ->step(0.001)
                    ->required(),
            ]),

            Panel::make('Container Information', [
                Select::make('Tray Type')->options([
                    '0MM' => '0MM',
                    '1MM' => '1MM',
                    '2MM' => '2MM',
                    'EMM' => 'EMM',
                    'EM1' => 'EM1',
                ])->hideFromIndex(),

                Text::make('Min 1FT', 'min1ft')
                    ->help("Required if TRAY TYPE=MMM. The minimum value is 85% of MAX1FT Value. Raise to next Integer, e.g., 242*.85=205.7 use 206")
                    ->nullable(),
                Text::make('Max 1FT', 'max1ft')
                    ->help("Required if TRAY TYPE=MMM. The maximum value is to divide the mail-piece Thickness into 21, then use Integer value, e.g., 10.25/.0425=241.176 use 241")
                    ->nullable(),
                Text::make('Min 2FT', 'min2ft')
                    ->help("For MMM, 2MM and EMM the minimum value is 85% of MAX2FT Value. Raise to next Integer, e.g., 495*.85=420.75 use 421\nFor OMM - Flat Trays the minimum value is to divide the mail-piece Thickness into 8\" then raise to next Integer value, e.g., 8/.0425=188.235 use 189\nFor OMM - Sacks minimum required at 125 pieces or 15lbs.")
                    ->nullable(),
                Text::make('Max 2FT', 'max2ft')
                    ->help("For MMM and 2MM the maximum value is to divide mail-piece Thickness into 21 then use Integer value, e.g., 21/.0425=494.117 use 494\nFor EMM the maximum value is to divide mail-piece Thickness into 21.75 then use Integer value, e.g., 21.75/.0425=511.764 use 511\nFor OMM - Flat Trays the maximum value is to divide mail-piece Thickness into 11.25\" then use Integer value, e.g., 11.25/.0425=264.705 use 264\nFor OMM - Sacks the maximum value is to divide mail-piece Weight into 70lbs. then use Integer value, e.g., 11.25/.0563=1243.339 use 1243")
                    ->nullable(),

            ]),

            Panel::make('Presort Information', [
                Boolean::make('Print Barcode?', 'print_barcode')
                    ->help("0 = Not print a barcode of any type; 1 = Printing a barcode of type POSTNET, IMb or IMpb")
                    ->default(false)
                    ->hideFromIndex(),
                Boolean::make('Print IMB?', 'print_imb')
                    ->help("0 = Not Claiming Full Service IMB Rates; 1 = Claiming Full Service IMB Rates")
                    ->default(false)
                    ->hideFromIndex(),
                Number::make('Weight', 'piece_weight')
                    ->step(0.01)
                    ->required(),
                Boolean::make('Include CRRT', 'include_crrt')
                    ->help("0 = Do not include the Carrier Route Level presort; 1 = Include the Carrier Route Level presort (if applicable)")
                    ->default(false)
                    ->hideFromIndex(),
                Boolean::make('include Non-Zip+4', 'include_non_zip4')
                    ->help("0 = Do not included Non-ZIP+4 records; Include Non-ZIP+4 records")
                    ->default(false)
                    ->hideFromIndex(),
                Boolean::make('Reverse', 'print_reverse')
                    ->help("0 = Do not prepare in Reverse Order (Default); 1 = Prepare in Reverse Order (Typically used when printing address directly on mail-piece and address print image falls face-up when exiting the printer)")
                    ->default(false)
                    ->hideFromIndex(),
            ]),

            Panel::make('Mailing Statement Information', [
                KeyValue::make('Mailing Agent', 'mailing_agent')
                    ->nullable()
                    ->withMeta([
                        'value' => $this->mailing_agent ?? [
                            'mailing_agent_name_address' => '|Point B Printing Solutions|9350 W Broadway Ave Ste 160|Brooklyn Park MN 55445-1906',
                            'mailing_agent_crid' => '4849338',
                            'mailing_agent_phone' => '9528383500',
                            'mailing_agent_mailer_id' => '120760'
                        ]
                    ])
                    ->disableAddingRows()
                    ->disableEditingKeys()
                    ->disableDeletingRows()
                    ->rules('json')
                    ->default([
                        'mailing_agent_name_address' => '|Point B Printing Solutions|9350 W Broadway Ave Ste 160|Brooklyn Park MN 55445-1906',
                        'mailing_agent_crid' => '4849338',
                        'mailing_agent_phone' => '9528383500',
                        'mailing_agent_mailer_id' => '120760'
                    ]),

                KeyValue::make('Prepared For')
                    ->nullable()
                    ->withMeta([
                        'value' => $this->prepared_for ?? [
                                'prepared_for_name_address' => '',
                                'prepared_for_crid' => ''
                            ]
                    ])
                    ->disableAddingRows()
                    ->disableEditingKeys()
                    ->disableDeletingRows()
                    ->rules('json'),

                KeyValue::make('Permit Holder')
                    ->nullable()
                    ->withMeta([
                        'value' => $this->permit_holder ?? [
                            'permit_holder_name_address' => '',
                            'permit_holder_crid' => '',
                            'mail_permit_number' => '',
                            'permit_holder_mailer_id' => ''
                        ]
                    ])
                    ->disableAddingRows()
                    ->disableEditingKeys()
                    ->disableDeletingRows()
                    ->rules('json'),

                Boolean::make('Political Mail', 'political_mail')->default(false)->hideFromIndex(),
                Boolean::make('Election Mail', 'election_mail')->default(false)->hideFromIndex(),

            ]),

            Panel::make('Mail.dat File Output Settings', [
                Boolean::make('Mail.dat PDR', 'maildat_pdr')
                    ->help("1 = Maildat.pdr will be created instead of the Maildat.pbc 0 = Maildat.pbc will be created instead of the Maildat.pdr")
                    ->default(false)
                    ->hideFromIndex(),
            ]),

            Panel::make('Filters to Exclude from Presort', [
                Boolean::make('COA Flag Only', 'coa_flag_only')
                    ->help("COA represents: A match to a Move in the NCOALink data that would change the original address to the new address. Set 'coa_flag_only' to 1 and the CASS Certified Address will not be changed to a COA value.  Only the following fields will be updated ffapplied_; matchflag_; movedate_; movetype_; nxi_; ank_.  The standardized address fields will be left untouched.")
                    ->default(false)
                    ->hideFromIndex(),
                Boolean::make('NCOALink Exclude: Moved - COA Matches', 'filter_ncoa_01')->default(false)->hideFromIndex(),
                Boolean::make('NCOALink Exclude: Moved - New Address cannot be confirmed', 'filter_ncoa_02')->default(false)->hideFromIndex(),
                Boolean::make('NCOALink Exclude: Moved - Left No Forwarding', 'filter_ncoa_03')->default(false)->hideFromIndex(),
                Boolean::make('NCOALink Exclude: Moved - Foreign Country', 'filter_ncoa_04')->default(false)->hideFromIndex(),
                Boolean::make('NCOALink Exclude: Moved - New State', 'filter_ncoa_05')->default(false)->hideFromIndex(),
                Boolean::make('NCOALink Exclude: Individual Match', 'filter_ncoa_06')->default(false)->hideFromIndex(),
                Boolean::make('NCOALink Exclude: Family Match', 'filter_ncoa_07')->default(false)->hideFromIndex(),
                Boolean::make('NCOALink Exclude: Business Match', 'filter_ncoa_08')->default(false)->hideFromIndex(),
                Boolean::make('CASS Exclude: Unit number provided but not verified', 'filter_cass_02')->default(false)->hideFromIndex(),
                Boolean::make('CASS Exclude: Unit number missing from known high-rise address', 'filter_cass_03')->default(false)->hideFromIndex(),
                Boolean::make('CASS Exclude: Vacant', 'filter_cass_04')->default(false)->hideFromIndex(),
                Boolean::make('CASS Exclude: Business Address', 'filter_cass_05')->default(false)->hideFromIndex(),
                Boolean::make('CASS Exclude: Private Mail Box Address', 'filter_cass_06')->default(false)->hideFromIndex(),
                Boolean::make('CASS Exclude: Address not valid', 'filter_cass_07')->default(false)->hideFromIndex(),
                Boolean::make('CASS Exclude: Missing address element(s)', 'filter_cass_08')->default(false)->hideFromIndex(),
                Boolean::make('CASS Exclude: Foreign', 'filter_cass_09')->default(false)->hideFromIndex(),
                Boolean::make('CASS Exclude: Military Addresses', 'filter_cass_10')->default(false)->hideFromIndex(),
            ]),

            Panel::make('Map Columns to Accuzip Structure', [
                KeyValue::make('Column Map Configuration', 'column_mapping')
                    ->nullable()
                    ->withMeta([
                        'value' => $this->column_mapping ?? (new ColumnMapData())->toArray()
                    ])
                    ->disableAddingRows()
                    ->disableDeletingRows()
                    ->disableEditingKeys()
                    ->rules('json'),
            ]),

            HasMany::make('Quotes', 'quotes'),
        ];
    }

    public function cards(NovaRequest $request)
    {
        return [];
    }

    public function filters(NovaRequest $request)
    {
        return [];
    }

    public function lenses(NovaRequest $request)
    {
        return [];
    }

    public function actions(NovaRequest $request)
    {
        return [];
    }
}
